/* 
 * File:   main.cpp
 * Author: Alexis López Zubieta
 *
 * Created on 13 de marzo de 2012, 16:01
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

typedef struct {
    GList * adyacentes;
} Grafo;


#define MAXNODOS 10000
#define MAXARISTAS 100

void grafo_init(Grafo *G, int nnodos) {
    while (nnodos > 0) {
        G->adyacentes = g_list_append(G->adyacentes, g_list_alloc());
        nnodos --;
    }
}

void grafo_destroy(Grafo *G) {
    GList *ptr = G->adyacentes;

    while (ptr != NULL) {
        g_list_free(ptr->data);
        ptr = ptr->next;
    }
    g_list_free(G->adyacentes);
}

GList * grafo_get_nodo(Grafo *G, int nodo) {
    nodo--;
    GList *ptr = G->adyacentes;

    while (ptr != NULL && nodo > 0) {
        ptr = ptr->next;
        nodo--;
    }
    if (nodo > 0)
        return NULL;
    else
        return ptr;
}

void grafo_add_arista(Grafo *G, int origen, int destino) {
    GList *nodo, *adyacentes;

    nodo = grafo_get_nodo(G, origen);
    adyacentes = (GList *) nodo->data;

    nodo->data = g_list_append(adyacentes, GINT_TO_POINTER(destino));
}

int grafo_get_naristas(Grafo *G, int nodo) {
    GList *ptr = grafo_get_nodo(G, nodo);

    return g_list_length((GList *) ptr->data);
}

int grafo_get_nnodos(Grafo *G) {
    return g_list_length(G->adyacentes);
}



/*
 * Ejecuta un algoritmo de recorrido en profundidad.
 */
gboolean visitado[MAXNODOS];

void dfs(Grafo *G, int nodo) {
    if (visitado[nodo] == TRUE)
        return;
    visitado[nodo] = TRUE;

    GList *ptrNodo, *ptrAdyacentes;

    ptrNodo = grafo_get_nodo(G, nodo);
    ptrAdyacentes = (GList *) ptrNodo->data;

    while (ptrAdyacentes != NULL) {
        dfs(G, (int) ptrAdyacentes->data);
        ptrAdyacentes = ptrAdyacentes->next;
    }


}

int main(int argc, char** argv) {
    Grafo *G = (Grafo*) malloc(sizeof (Grafo));

    int i, j, k = 0;
    grafo_init(G, MAXNODOS);

    for (i = 0; i < MAXNODOS; i++) {
        for (j = 0; j < MAXARISTAS; j++) {
            grafo_add_arista(G, i, k);
            grafo_add_arista(G, k, i);
            k = (k + 1) % MAXNODOS;
        }
    }
    dfs(G, 0);

    grafo_destroy(G);

    return (EXIT_SUCCESS);
}

