/* 
 * File:   main.cpp
 * Author: Alexis López Zubieta
 *
 * Created on 13 de marzo de 2012, 16:01
 */

#include <cstdlib>
#include <iostream>
#include <list>

#define MAXNODOS 10000
#define MAXARISTAS 100

using namespace std;

class Grafo {
public:
    Grafo(int nnodos){
    while (nnodos > 0) {
        adyacente.push_back(list<int>());
        nnodos--;
    }
}
    virtual ~Grafo(){
    for (std::list< list<int> >::iterator it = adyacente.begin();
            it != adyacente.end(); it++) {
        it->clear();
    }
    adyacente.clear();
}

    void agregarArista(int origen, int destino){
    list<int> * nodo = getNodo(origen);

    nodo->push_back(destino);
}

    int getNnodos(){
    return adyacente.size();
}
    list<int> * getNodo(int nodo){
    nodo--;
    std::list< list<int> >::iterator it = adyacente.begin();

    while (it != adyacente.end() && nodo > 0) {
        it++;
        nodo--;
    }
    if (nodo > 0)
        return (std::list<int, std::allocator<int> > *) NULL;
    else
        return &(*it);
}
    int getNaristas(int nodo){
    list<int> * ptrnodo = getNodo(nodo);

    return ptrnodo->size();
}
    list< list<int> > adyacente;

};




bool visitado[MAXNODOS];

void dfs(Grafo *G, int v) {
    if (visitado[v] == true)
        return;
    visitado[v] = true;

    list<int> *nodo = G->getNodo(v);
    std::list<int>::iterator list_iter;

    for (list_iter = nodo->begin();
            list_iter != nodo->end(); list_iter++) {
        dfs(G, *list_iter);
    }
}

int main(int argc, char** argv) {
    Grafo *G = new Grafo(MAXNODOS);
    int k = 0;
    for (int i = 0; i < MAXNODOS; i++) {
        for (int j = 0; j < MAXARISTAS; j++) {
            G->agregarArista(i, k);
            G->agregarArista(k, i);
            k = (k + 1) % MAXNODOS;
        }
    }

    dfs(G, 0);

    G->~Grafo();

    return (EXIT_SUCCESS);
}

