using GLib;


const int MAXNODOS=10000;
const int MAXARISTAS=100;

public class Grafo : GLib.Object {
	public List< List<int> > * adyacentes;
	
	public Grafo(int nndodos) {
		
			while (nndodos > 0) {
				adyacentes->append( new List<int> () );
				nndodos --;
				}
		}
		
    ~ Demo() {
		unowned List< List<int> >  * it = adyacentes;
		unowned List< List<int> >  * prev;

		while (it != null) {
			prev = it;
			it = it->next;
			delete ( prev );
		}
    }
    
	public List<int>  * getNodo(int nodo){
		nodo--;
		unowned List< List<int> >  * it = adyacentes;

		while (it != null && nodo > 0) {
			it = it->next;
			nodo--;
		}
		if (nodo > 0)
			return null;
		else
			return it->data;
	}
    
    public void agregarArista(int origen, int destino){
		List<int> * nodo = getNodo(origen);

		nodo->append(destino);
	}
	
	public uint getNnodos() {
        return adyacentes->length();
    }

    public uint getNaristas(int nodo) {
        List<int> * ptr = getNodo(nodo);
        return ptr->length();
    }
    

}

 

bool[] visitado;
    
void dfs(Grafo *G, int v) {
    if ( visitado[v] == true)
        return;
    visitado[v] = true;

    List<int> *nodo = G->getNodo(v);
	unowned  List<int>  * it = nodo;

	while (it != null) {
		it = it->next;
		dfs(G, it->data);
	}
}

public static int main () {
	visitado = new bool[MAXNODOS];
    Grafo *G = new Grafo(MAXNODOS);
    int k = 0;
    for (int i = 0; i < MAXNODOS; i++) {
        for (int j = 0; j < MAXARISTAS; j++) {
            G->agregarArista(i, k);
            G->agregarArista(k, i);
            k = (k + 1) % MAXNODOS;
        }
    }
    dfs(G, 0);

    
    delete(G);

   return (0);
}


