#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <signal.h>
#include <sys/types.h>
#include <termios.h>

struct termios tsave;


#define BUF_SIZE    4096 /* this is set to this value because it's the longest fragment we can read from a pipe  */
#define MAX_SAMPLE  32766

#define CLIP        30000
#define CLIP_A      ((MAX_SAMPLE-CLIP)*(MAX_SAMPLE-CLIP))
#define CLIP_B      (MAX_SAMPLE-2*CLIP)


int audio_fd;  
short audio_buffer[BUF_SIZE];  
int   process_buffer[BUF_SIZE];

typedef struct {
  short inbuf[BUF_SIZE];
  float volume;
  float speed;
  int on;
  int stream;
  FILE *fstr;           /* use std buffering to simplify things */
  pid_t pid;
  int argindx;
} channel;

channel ch1,ch2;



void spawn_stream(char *filename,channel *ch){
int strm[2];
pid_t pid;
/* create pipe */
pipe(strm);
 pid=fork();
 if(pid){
   (*ch).pid=pid;
   close(strm[1]);
   (*ch).stream=strm[0];
   (*ch).fstr=fdopen((*ch).stream,"rb");
 } else {
   close(strm[0]);
   close(1);
   dup(strm[1]);
   close(strm[0]);
   close(strm[1]);
   execlp("mpg123","mpg123","-s",filename,NULL);
 }
}

void open_sound_device(void){
int format;
int stereo = 1;   
int rate = 44100;
 if ((audio_fd = open("/dev/dsp", O_WRONLY , 0)) == -1)  
   {  
     perror("/dev/dsp");  
     exit(1);  
   }   
 format = AFMT_S16_LE;  
 if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1)  
   {  
     perror("SNDCTL_DSP_SETFMT");  
     exit(1);  
   }
 if (format != AFMT_S16_LE)  {
   fprintf(stderr,"Output format not set correctly");
 }
 if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo)==-1)
   {
     perror("SNDCTL_DSP_STEREO");
     exit(1);
   }
if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &rate)==-1)  
  { /* Fatal error */  
    perror("SNDCTL_DSP_SPEED");  
    exit(1);  
  }  
}


void close_sound_device(void){
close(audio_fd);
}

void init_channel(channel *ch){
int i;
 for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
(*ch).volume=1.0;
(*ch).speed=1.0;
(*ch).on=0;
(*ch).stream=0;
(*ch).pid=0;
(*ch).argindx=1;
}

void kill_channel(channel *ch){
int i;
 if((*ch).pid>0){
   kill((*ch).pid,15);
   (*ch).pid=0;
   (*ch).on=0;
 } else {
   if((*ch).stream>2)
     close((*ch).stream);
   (*ch).pid=0;
   (*ch).on=0;
 }
 for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
}

/* step up through the list of tracks */
void change_channel(channel *ch,int argc,char *argv[],int inc){
kill_channel(ch);
(*ch).argindx+=inc;
if((*ch).argindx>=argc)
  (*ch).argindx=1;
else if((*ch).argindx<1)
  (*ch).argindx=argc-1;
/* reset the speed */
 (*ch).speed=1;
spawn_stream(argv[(*ch).argindx],ch);
}


/* get the audio for one channel - should include speedup and slowdown here */
void get_audio(channel *ch,int *buf){
static short adat[BUF_SIZE],inbuf[BUF_SIZE*4];
int i,j;
 if((*ch).on){
   if((*ch).speed==1.0)
     i=fread(adat,2,BUF_SIZE,(*ch).fstr);
   else {
     j=(BUF_SIZE>>1)*(*ch).speed;
     j<<=1;
     i=fread(inbuf,2,j,(*ch).fstr);
     if(i<j){
       kill_channel(ch);
       for(;i<j;i++)
	 inbuf[i]=0;
     }
     for(i=0;i<(BUF_SIZE/2);i++){
       j=i*(*ch).speed;
       adat[i*2]=inbuf[j*2];
       adat[i*2+1]=inbuf[j*2+1];
     }
     i=BUF_SIZE;
   }
   if(i<BUF_SIZE){
     kill_channel(ch);
     for(;i<BUF_SIZE;i++)
       adat[i]=0;
   }
   for(i=0;i<BUF_SIZE;i++)
     buf[i]+=adat[i]*(*ch).volume;
   
 }
}

void play_chunks(void){
int i,num;
num=BUF_SIZE;

for(i=0;i<BUF_SIZE;i++) process_buffer[i]=0;

get_audio(&ch1,process_buffer);
get_audio(&ch2,process_buffer);

for(i=0;i<num;i++) {
  if((process_buffer[i]<CLIP)&&(process_buffer[i]>-CLIP))
    audio_buffer[i]=(short)(process_buffer[i]);
  else if (process_buffer[i]>0) 
    audio_buffer[i]=MAX_SAMPLE-(CLIP_A/(CLIP_B+process_buffer[i]));
  else 
    audio_buffer[i]=-(MAX_SAMPLE-(CLIP_A/(CLIP_B-process_buffer[i])));
}

write(audio_fd,audio_buffer,num*2);
}


/* sets canonical input mode */
void set_terminal(void){
struct termios tbuf;
tcgetattr(0,&tbuf);
tsave=tbuf;
tbuf.c_lflag &= ~(ECHO | ICANON | ISIG);
tbuf.c_cc[VMIN] = tbuf.c_cc[VTIME] = 0;
tcsetattr(0,TCSANOW,&tbuf);
}

/* restore the settings */
void restore_terminal(void){
tcsetattr(0,TCSANOW,&tsave);
}


void controls(int argc,char *argv[],char inp){
  switch(inp){
  case '1': 
    change_channel(&ch1,argc,argv,1);
    break;
  case 'q':
    change_channel(&ch1,argc,argv,-1);
    break;
  case 'w':
    change_channel(&ch1,argc,argv,0);
    break;
  case '2':
    if(ch1.on) ch1.on=0;
    else ch1.on=1;
    break;
  case 'a': 
    change_channel(&ch2,argc,argv,1);
    break;
  case 'z':
    change_channel(&ch2,argc,argv,-1);
    break;
  case 'x':
    change_channel(&ch2,argc,argv,0);
    break;
  case 's':
    if(ch2.on) ch2.on=0;
    else ch2.on=2;
    break;
  case '3':
    ch1.volume+=0.05;
    printf("%f\n",ch1.volume);
    break;
  case 'e':
    ch1.volume-=0.05;
    if(ch1.volume<0)
      ch1.volume=0;
    printf("%f\n",ch1.volume);
    break;
  case 'd':
    ch2.volume+=0.05;
    printf("%f\n",ch2.volume);
    break;
  case 'c':
    ch2.volume-=0.05;
    if(ch2.volume<0)
      ch2.volume=0;
    printf("%f\n",ch2.volume);
    break;
  case '4':
    ch1.speed*=1.005;
    break;
  case 'r':
    ch1.speed*=0.995;
    break;
  case 'f':
    ch2.speed*=1.005;
    break;
  case 'v':
    ch2.speed*=0.995;
    break;
    
  }
}


int main (int argc,char *argv[]){
int argindex;
char inp;

signal(SIGCHLD,SIG_IGN);
open_sound_device();
set_terminal();
init_channel(&ch1);
init_channel(&ch2);
change_channel(&ch1,argc,argv,0);
change_channel(&ch2,argc,argv,0);

 while(inp!='+'){
   play_chunks();
   inp=getchar();
   controls(argc,argv,inp);
 }

restore_terminal();
close_sound_device();
}




