#!/usr/bin/perl

use strict;
use warnings;

use MIME::Parser;

use Data::Dumper;

my $parser = new MIME::Parser;

$parser->output_under("/tmp/parser");

if ($#ARGV != 0) {
	print STDERR "Usage: $0 message.eml\n";
	exit 64;
}

open(EMAIL, '<', $ARGV[0]) or die;

my $entity = $parser->parse(\*EMAIL);

foreach my $part ($entity->parts) {
	if ($part->mime_type eq 'message/rfc822') {
		print Dumper($part);
	}
}
