/*
 *  Copyright (C) 2002 , Torsten Mohr, tmohr@s.netic.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> // snprintf

#include <unistd.h> // getopt

#include <assert.h> // assert

#include "slImg.h"
#include "slPng.h"
#include "slLAV.h"


#define FNBUF	1024

#define QWE fprintf(stderr, "file '%s', func '%s', line %i\n", __FILE__, __func__, __LINE__)

static SL_LAV_IN in_avi;
static SL_LAV_OUT out_avi;
static SL_IMG in_pic;
static SL_IMG out_pic;

static char fnbuf[FNBUF];
static SL_IMG* pics;
static SL_IMG pic;
static int k = 0;
static int b = -1;
static int e = -1;
static int offset = 0;
static char* namepattern = NULL;
static char* instream = NULL;
static char* outstream = NULL;
static int seq = -1;
static int fade_in = 0;
static int fade_out = 0;
static int len;
static int x_off = 0;
static int y_off = 0;


static void usage(void) {
	fprintf(stderr,
		"pngoverlay [options]\n"
		"           -p filename pattern, e.g. f%04d.png\n"
		"           -b first frame number, e.g. 1\n"
		"           -e last frame number\n"
		"           -k keep the loaded pics\n"
		"           -a offset in input stream\n"
		"           -s sequence of pics, how many pics should be output\n"
		"           -i input stream name\n"
		"           -o output stream name\n"
		"           -r fade in from alpha invisible\n"
		"           -t fade out to alpha invisible\n"
		"           -x x offset for overlay\n"
		"           -y y offset for overlay\n"
	);
}


static SL_IMG* img(int nr) {
	int ret;

	if(k) {
		return &pics[nr];
	}
	else {
		snprintf(fnbuf, FNBUF, namepattern, nr);
		printf("reading %s\n", fnbuf);

		ret = slPngRead(fnbuf, &pic);
		if(ret != 0) {
			printf("slPngRead returned %i for %s\n", ret, fnbuf);
			exit(1);
		}

		return &pic;

	}
}


int main(int argc, char** argv) {
	char* ep;
	int i, j, ret, nr;
	int w, h;
	unsigned long int tmp;
	SL_IMG* imgp;

	while(i = getopt(argc,argv, "kt:p:b:e:a:i:o:s:r:t:x:y:h"), i != -1) {
		switch(i) {
			case 'h':
				usage();
				exit(1);
				break;

			case 'k':
				k = 1;
				break;

			case 'i':
				instream = optarg;
				break;

			case 'o':
				outstream = optarg;
				break;

			case 'p':
				namepattern = optarg;
				break;

			case 'r':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "fade_in not valid\n");
					exit(1);
				}
				fade_in = tmp;
				break;

			case 't':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "fade_out not valid\n");
					exit(1);
				}
				fade_out = tmp;
				break;

			case 's':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "sequence not valid\n");
					exit(1);
				}
				seq = tmp;
				break;

			case 'a':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "offset not valid\n");
					exit(1);
				}
				offset = tmp;
				break;

			case 'b':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "b not valid\n");
					exit(1);
				}
				b = tmp;
				break;

			case 'e':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				if(tmp < 0) {
					fprintf(stderr, "e not valid\n");
					exit(1);
				}
				e = tmp;
				break;

			case 'x':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				x_off = tmp;
				break;

			case 'y':
				tmp = strtoul(optarg, &ep, 0);
				if(*ep != 0) {
					fprintf(stderr, "didn't recognise '%s'\n", optarg);
					exit(1);
				}
				y_off = tmp;
				break;

			case '?':
			case ':':
			default:
				fprintf(stderr, "got %i\n", i);
				usage();
				exit(1);
				break;
		}
	}

	len = e - b;

	if(len < 0) {
		printf("end pic is less than start pic\n");
		usage();
		exit(1);
	}

	if(instream == NULL) {
		fprintf(stderr, "no input stream specified\n");
		usage();
		exit(1);
	}

	if(outstream == NULL) {
		fprintf(stderr, "no output stream specified\n");
		usage();
		exit(1);
	}

	if(fade_in + fade_out > len) {
		fprintf(stderr, "fading sequence longer than sequence itself\n");
		usage();
		exit(1);
	}

	if(k) {
		pics = calloc(sizeof(SL_IMG), e-b);

		for(i = b; i <= e; i++) {
			snprintf(fnbuf, FNBUF, namepattern, i);
			printf("reading %s\n", fnbuf);

			ret = slPngRead(fnbuf, &pics[i]);
			if(ret != 0) {
				printf("slPngRead returned %i for '%s', not enough memory?\n", ret, fnbuf);
				exit(1);
			}
		}
	}

	ret = slLAVReadInit(&in_avi, instream);
	if(ret != 0) {
		fprintf(stderr, "read-init failed for %s\n", instream);
		exit(1);
	}

	ret = slImgMalloc(&in_pic, in_avi.w, in_avi.h);
	if(ret != 0) {
		fprintf(stderr, "malloc for picture failed for %s\n", instream);
		exit(1);
	}

	ret = slLAVWriteInit(&out_avi, outstream, in_avi.w, in_avi.h, 70, 0);
	if(ret != 0) {
		fprintf(stderr, "read-init failed for %s\n", instream);
		exit(1);
	}

	for(i = 0; i < in_avi.num_frames; i++) {
		printf("processing frame %i\n", i);

		ret = slLAVReadFrame(&in_avi, &in_pic, i);
		if(ret != 0) {
			fprintf(stderr, "reading frame %i failed\n", i);
			exit(1);
		}

/*		if(i == 0) {
			for(j = 0; j < 768; j++) {
				in_pic.data[4*j] = 255;
				in_pic.data[4*j+1] = 255;
				in_pic.data[4*j+2] = 0;
				in_pic.data[4*j+3] = 255;
			}
			slPngWrite("f1.png", &in_pic);
			slImgFlipY(&in_pic);
			slPngWrite("f2.png", &in_pic);
			slImgFlipY(&in_pic);
		} // */

		nr = i - offset;

		if(b <= nr && nr <= e) {
			imgp = img(nr);
			slImgOverlay(&in_pic, imgp, x_off, y_off);
		} // */

		ret = slLAVWriteFrame(&out_avi, &in_pic);
		if(ret != 0) {
			fprintf(stderr, "writing frame %i failed\n", i);
			exit(1);
		}
	}

	slLAVInClose(&in_avi);
	slLAVOutClose(&out_avi);


	if(k) {
		for(i = b; i <= e; i++) {
			slPngFree(&pics[i]);
		}
	}
	else {
		slPngFree(&pic);
	}

	return EXIT_SUCCESS;
}



