#include <stdio.h>
#include <stdlib.h>

#include "slImg.h"


static unsigned char* adr(SL_IMG* img, int x, int y) {
	return &img->data[4*(y * img->w + x)];
}


void slImgOverlay(SL_IMG* target, SL_IMG* source, int x_off, int y_off) {
	unsigned char* t;
	unsigned char* s;
	unsigned char a;
	int x, y, xx, yy;

	for(y = 0; y < target->h; y++) {
		for(x = 0; x < target->w; x++) {
			xx = x + x_off;
			yy = y + y_off;
			if(0 <= xx && xx < source->w && 0 <= yy && yy < source->h) {
				t = adr(target, x, y);
				s = adr(source, xx, yy);
				a = s[3];
				if(a != 0) {
					t[0] = (t[0] * (255-a) + s[0] * a) >> 8;
					t[1] = (t[1] * (255-a) + s[1] * a) >> 8;
					t[2] = (t[2] * (255-a) + s[2] * a) >> 8;
				}
			}
			else {

			}
		}
	}
}


int slImgMalloc(SL_IMG* img, int w, int h) {
	img->w = w;
	img->h = h;

	img->data = (unsigned char*)malloc(4*w*h);

	return img->data == NULL ? 1 : 0;
}


void slImgFree(SL_IMG* img) {
	free(img->data);
}


int slImgWriteRGBA(SL_IMG* img, char* name) {
	FILE* out;
	int ret;

	out = fopen(name, "wb");
	if(out == NULL) {
		return -1;
	}

	fwrite(img->data, 4, img->w * img->h, out);
	fclose(out);

	return 0;
}


void slImgFlipY(SL_IMG* img) {
	int x, y;
	unsigned char* a1;
	unsigned char* a2;
	unsigned char tmp;

	for(y = 0; y < img->h/2; y++) {
		a1 = adr(img, 0, y);
		a2 = adr(img, 0, img->h - y);

		for(x = 0; x < 4*img->w; x++) {
			tmp = a1[x];
			a1[x] = a2[x];
			a2[x] = tmp;
		}
	}
}


void slImgGrayscale(SL_IMG* img) {
	int x, y, tmp;
	unsigned char* a;

	a = img->data;
	for(y = 0; y < img->h; y++) {
		for(x = 0; x < img->w; x++) {
			tmp = a[0]+a[1]+a[2];
			a[0] = a[1] = a[2] = tmp / 3;
			a[3] = 255;
			a += 4;
		}
	}
}


void slImgBlend(SL_IMG* img, int l, int r) {
	int x, y;
	unsigned char* a;
	int b = 0;
	int w = 255;
	int tmp;
	int d;

	if(r < l) {
		b = 255;
		w = 0;
		tmp = l;
		l = r;
		r = tmp;
	}

	d = r-l;

	for(y = 0; y < img->h; y++) {
		for(x = 0; x < img->w; x++) {
			a = adr(img, x, y);
			a[3] = 255;
			if(x < l) {
				a[0] = a[1] = a[2] = b;
			}
			else if(r < x) {
				a[0] = a[1] = a[2] = w;
			}
			else {
				tmp = (x-l)*w/d + (r-x)*b/d;
				a[0] = a[1] = a[2] = tmp;
			}
		}
	}
}


void slImgMix(SL_IMG* combined, SL_IMG* source, SL_IMG* mask) {
	int x, y;
	unsigned char* to;
	unsigned char* s;
	unsigned char* m;

	// FIXME: size checking
	for(y = 0; y < combined->h; y++) {
		for(x = 0; x < combined->w; x++) {
			to = adr(combined, x, y);
			s = adr(source, x, y);
			m = adr(mask, x, y);
			to[0] = ((int)to[0] * (int)(255-m[0]) + (int)s[0] * (int)m[0]) >>8;
			to[1] = ((int)to[1] * (int)(255-m[1]) + (int)s[1] * (int)m[1]) >>8;
			to[2] = ((int)to[2] * (int)(255-m[2]) + (int)s[2] * (int)m[2]) >>8;
			to[3] = 255;
		}
	}
}


