#ifndef SL_IMG_H
#define SL_IMG_H 1


typedef struct {
	unsigned char* data;
	int w;
	int h;
} SL_IMG;


extern int slImgMalloc(SL_IMG* img, int w, int h);
extern void slImgFree(SL_IMG* img);

extern void slImgFlipY(SL_IMG* img);

extern void slImgOverlay(SL_IMG* target, SL_IMG* source, int x_off, int y_off);
extern void slImgGrayscale(SL_IMG* img);

/* left side will be black, right side white */
extern void slImgBlend(SL_IMG* img, int l, int r);

extern void slImgMix(SL_IMG* combined, SL_IMG* source, SL_IMG* mask);

#endif

