#ifndef SL_LAV_H
#define SL_LAV_H 1

#define HAVE_STDINT_H

#include <lav_io.h>

#include "slImg.h"

#define SL_LAV_MAXX		768
#define SL_LAV_MAXY		576

#define SL_LAV_TEXTURE_SIZE		1024


#define SL_LAV_SUBX 	2
#define SL_LAV_SUBY 	2

#define SL_LAV_BS_Y		(SL_LAV_MAXX * SL_LAV_MAXY)
#define SL_LAV_BS_C		(SL_LAV_MAXX * SL_LAV_MAXY / SL_LAV_SUBX / SL_LAV_SUBY)
#define SL_LAV_BS_RGB	(SL_LAV_MAXX * SL_LAV_MAXY * 4)


typedef struct {
	lav_file_t* in;
	int w;
	int h;
	int num_frames;
	int act_frame;
//	unsigned char* rgb_data;
} SL_LAV_IN;


typedef struct {
	lav_file_t* out;
	int w;
	int h;
	int inter;
	int quality;
//	unsigned char* rgb_data;
} SL_LAV_OUT;



extern int slLAVReadInit(SL_LAV_IN* src, char* fname);
extern int slLAVReadFrame(SL_LAV_IN* src, SL_IMG* img, int num);
extern int slLAVInClose(SL_LAV_IN* in);

extern int slLAVWriteInit(SL_LAV_OUT* out, char* fname, int w, int h, int qual, int inter);
extern int slLAVWriteFrame(SL_LAV_OUT* out, SL_IMG* img);
extern int slLAVOutClose(SL_LAV_OUT* out);



#endif

