#include <stdio.h>
#include <stdlib.h>
#include <string.h> // snprintf

#include <png.h>

#include "slPng.h"
#include "slImg.h"


#define QWE fprintf(stderr, "file '%s', func '%s', line %i\n", __FILE__, __func__, __LINE__)


static int min(int a, int b) {
	return a > b ? b : a;
}


static int read_chunk_callback(png_structp ptr, png_unknown_chunkp chunk) {
	/* The unknown chunk structure contains your chunk data: */
	png_byte name[5];
	png_byte *data;
	png_size_t size;
	/* Note that libpng has already taken care of the CRC handling */

	/* put your code here.  Return one of the following: */

//	return -n; /* chunk had an error */
	return 0; /* did not recognize */
//	return n; /* success */
}


void slPngFree(SL_IMG* png) {
	free(png->data);
}


int slPngRead(char* fname, SL_IMG* png) {
	int i, ret;
	unsigned char header[8];
	png_structp png_ptr;
	png_infop info_ptr;
	png_infop end_info;
	png_bytepp row_pointers;
	png_uint_32 width;
	png_uint_32 height;
	int bit_depth;
	int color_type;
	int interlace_type;
	int compression_type;
	int filter_method;
	png_byte channels;
	png_uint_32 rowbytes;
	FILE* png_in;


	png_in = fopen(fname, "rb");
	if(png_in == NULL) {
		return 1;
	}

	ret = fread(header, 1, 8, png_in);
	if(ret != 8) {
		printf("didn't read 8 bytes, read %i\n", ret);
		fclose(png_in);
		return 2;
	}

	ret = png_sig_cmp(header, 0, 8);
	if(ret != 0) {
		fclose(png_in);
		return 3;
	}

	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if(png_ptr == NULL) {
		fclose(png_in);
		return 4;
	}

	info_ptr = png_create_info_struct(png_ptr);
	if(!info_ptr) {
		png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
		fclose(png_in);
		return 5;
	}

	end_info = png_create_info_struct(png_ptr);
	if(!end_info) {
		png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
		fclose(png_in);
		return 6;
	}

	if(setjmp(png_jmpbuf(png_ptr))) {
		png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
		fclose(png_in);
		return 7;
	}

	png_init_io(png_ptr, png_in);
	png_set_sig_bytes(png_ptr, 8);
	png_set_read_user_chunk_fn(png_ptr, NULL, read_chunk_callback);

	png_set_keep_unknown_chunks(png_ptr, 3, NULL, 0);

	png_read_info(png_ptr, info_ptr);

	png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
		&interlace_type, &compression_type, &filter_method);
	channels = png_get_channels(png_ptr, info_ptr);
	rowbytes = png_get_rowbytes(png_ptr, info_ptr);

	/* set the options */
	png_set_gray_1_2_4_to_8(png_ptr);
	png_set_palette_to_rgb(png_ptr);
	png_set_expand(png_ptr);
	png_set_strip_16(png_ptr);
	png_set_packing(png_ptr);
	png_set_gray_to_rgb(png_ptr);
	png_set_tRNS_to_alpha(png_ptr);


	png_read_update_info(png_ptr, info_ptr);

	png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
		&interlace_type, &compression_type, &filter_method);
	channels = png_get_channels(png_ptr, info_ptr);
	rowbytes = png_get_rowbytes(png_ptr, info_ptr);

	/* set up the memory */
	row_pointers = (png_bytepp)png_malloc(png_ptr, sizeof(png_bytep)*height);
	if(row_pointers == NULL) {
		printf("couldn't get memory for row_pointers\n");
		return 8;
	}
	png->data = (png_bytep)malloc(4*width*height);
	if(png->data == NULL) {
		printf("couldn't get memory for image data\n");
		return 9;
	}
	for(i = 0; i < height; i++) {
		row_pointers[i] = &png->data[4*width*i];
	}

	/* read the image */
	png_read_image(png_ptr, row_pointers);

	png->w = width;
	png->h = height;

/*	printf("######################\n");
	printf("width %i, height %i\n", width, height);
	printf("bit_depth %i\n", bit_depth);
	printf("color_type %i\n", color_type);
	printf("interlace_type %i\n", interlace_type);
	printf("channels %i, rowbytes %i\n", channels, rowbytes); // */

/*	for(i = 0; i < min(height, 12); i++) {
		printf("row %i\n", i);
		show_row(row_pointers[i], rowbytes);
	} // */

	png_free(png_ptr, row_pointers);

	png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
	fclose(png_in);


	return 0;
}


int slPngWrite(char* fname, SL_IMG* png) {
	FILE* out;
	int i;
	png_structp png_ptr;
	png_infop info_ptr;
	png_bytepp rowpointers;

	out = fopen(fname, "wb");
	if(out == 0) {
		printf("couldn't write-open '%s'\n", fname);
		return 1;
	}

	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if (png_ptr == NULL) {
		fclose(out);
		printf("couldn't get png_write_struct\n");
		return 2;
	}

	info_ptr = png_create_info_struct(png_ptr);
	if (info_ptr == NULL) {
		fclose(out);
		png_destroy_write_struct(&png_ptr,  png_infopp_NULL);
		printf("couldn't get png_info_struct\n");
		return 3;
	}

	if (setjmp(png_jmpbuf(png_ptr))) {
		fclose(out);
		png_destroy_write_struct(&png_ptr, &info_ptr);
		printf("png_write: in setjmp...\n");
		return 4;
	}

	png_init_io(png_ptr, out);

	rowpointers = (png_bytepp)malloc(sizeof(png_bytep)*png->h);
	if(rowpointers == NULL) {
		fclose(out);
		png_destroy_write_struct(&png_ptr, &info_ptr);
		printf("couldn't get memory for rowpointers\n");
		return 5;
	}
	for(i = 0; i < png->h; i++) {
		rowpointers[i] = &png->data[4 * png->w * i];
	}

	png_set_IHDR(png_ptr, info_ptr, png->w, png->h, 8, PNG_COLOR_TYPE_RGB_ALPHA,
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);


	png_write_info(png_ptr, info_ptr);

	png_write_image(png_ptr, rowpointers);

	png_write_end(png_ptr, info_ptr);

	png_destroy_write_struct(&png_ptr, &info_ptr);

	fclose(out);


	return 0;
}


