package Apache::NavBar;

##Derived from work by Lincoln Stein in his article
##"A Dynamic Navigation Bar with mod_perl" in
##The Perl Journal, Issue #12, Vol.3, No.4

use strict;
use Apache::Constants qw(:common);
use Apache::File ();
use Apache::URI  ();
use Apache::OutputChain ();
use File::Basename;

use vars qw( @ISA $VERSION );
@ISA = qw(Apache::OutputChain);

my %BARS = ();
my %TB = ();
#my $TABLECOLOR  = '#C8FFFF';
my $ACTIVECOLOR = '#FF0000';
	
$VERSION = '0.07';

sub handler {
  my $r = shift;
  Apache::OutputChain::handler($r, __PACKAGE__);
}

sub PRINT {
  my $self = shift;
  my $r = $self->[0];
  my $bar = read_configuration($r);
  my $top = load_plate($r, 'top');
  my $bot = load_plate($r, 'bot');

  my $table = make_bar($r, $bar);
  $top = $top->plate;
  $bot = $bot->plate;
  local $_ = join '', @_;
  s!<BODY.*?>!<BODY BGCOLOR="#FFFFFF" LEFTMARGIN="0" TOPMARGIN="0">$top$table!is;
  s!</BODY>!$bot</BODY>!i;
  $self->Apache::OutputChain::PRINT($_);
}

sub make_bar {
  my ($r,$bar) = @_;            #Create the navigation bar
  my $current_url = $r->uri;
  my @cells;
  my $cells;
  foreach my $label ($bar->labels) {
    my $url   = $bar->url($label);
    my $level = $bar->level($label);
    my ($indent, $size, $cell, $color, $class);
    if ($level == 0) {
      $label = qq(<B>$label</B>);
      ($indent, $size) =  ('', 'SIZE="-0"'); 
    }
    else { ##Level 1 is the only other current level
      ($indent, $size) =  ('', 'SIZE="-1"');
    }
    ##If there's a url and the current url matches it, then
    ##the text is not a link and it's color is red.
    ##If there's a url and current url doesn't match it then
    ##we wrap it in an anchor tag
    ##If there's no url then leave it alone
    my $is_not_current = $current_url !~ /^$url/;
    if ($url and $is_not_current) { ##Active links
      ($color,$class) =  ('', 'active');
      $cell =qq($indent<A HREF="$url"><FONT $size $color>$label</FONT></A><BR><BR>);
    }
    elsif ($url) {  ##The link where we're at
      ($color,$class) =  (qq(COLOR="$ACTIVECOLOR"), 'inactive');
      $cell = qq($indent<FONT $size $color>$label</FONT><BR><BR>);
    }
    else {  ##Indexing markers
      ($color,$class) =  ('', 'active');
      $cell = qq($indent<FONT $size $color>$label</FONT><BR><BR>);
    }
    push @cells, $cell;
  }
  @cells = ('&nbsp;') unless @cells;
  $cells = join "\n", @cells, '';
  my $nav = <<EOH;
<!-- Main Body Edited: Left Menu; Right Page  -->
<TR>
<TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="#AEBD8E">
$cells
</TD>
<TD ALIGN="LEFT" VALIGN="TOP" COLSPAN=5>
<TABLE CELLPADDING="20">
<TR><TD>
EOH

  return $nav;
}

sub read_configuration {
  my $r = shift;
  my $uri = $r->parsed_uri();
  my $mod_time;
  my $conf_file = join '/', $r->document_root(),
			    dirname($uri->path), 'navConf.txt';
  ##We always return an object, even if there's no configuration file
  ##so that the page is wrapped by the header and footer.
  if (-e $conf_file) {
    $mod_time = (stat _)[9];
  }
  else {
    $conf_file = '';
    $mod_time = 0;
  }

  return $BARS{$conf_file} if $BARS{$conf_file} &&  
                              $BARS{$conf_file}->modified >= $mod_time;
  return $BARS{$conf_file} = Apache::NavBar::NavBar->new($conf_file);

}

sub load_plate {
  my ($r, $name) = @_;
  my $conf_file = join '.', $r->dir_config('TBtemplate'), $name;
  my $mod_time;
  my $tb;
  $conf_file = $r->server_root_relative($conf_file);
  if (-e $conf_file) {
    $mod_time = (stat _)[9];
  }
  else {
    $conf_file = '';
    $mod_time = 0;
  }

  return $TB{$conf_file} if $TB{$conf_file} &&  
                              $TB{$conf_file}->modified >= $mod_time;
  return $TB{$conf_file} = Apache::NavBar::NavTopBot->new($conf_file);

}

package Apache::NavBar::NavBar;

sub new {                        # create a new NavBar object
  my ($class, $conf_file) = @_;
  my (@c, %c, %d);
  unless ($conf_file) {
    return bless { 'labels'   => [],
		   'url'      => {},
		   'levels'   => {},
		   'modified' => 0 }, $class;
  }
  my $fh = Apache::File->new($conf_file) || return;
  local $/ = "\n";
  while (<$fh>) {
    tr/\r//d;
    chomp;
    my ($label, $url, $level) = split /\t/;
    push @c, $label;
    $c{$label} = $url;
    $d{$label} = $level;
  }
  return bless { 'labels'   => \@c,
		 'url'      => \%c,
		 'levels'   => \%d,
		 'modified' => (stat $conf_file)[9] }, $class;
}

#return ordered list of all the URLs in the navigation bar
sub url { return $_[0]->{'url'}->{$_[1]} }

#return the label for a particular URL in the bar
sub labels { return @{shift->{'labels'}}; }

#return the level for a particular URL in the bar
sub level { return $_[0]->{'levels'}->{$_[1]} }

#return the modification date of the configuration file
sub modified { return $_[0]->{'modified'}; }

package Apache::NavBar::NavTopBot;

sub new {
  my ($class, $template) = @_;
  unless ($template) {
    return bless { 'plate' => '',
		   'modified' => 0 }, $class;
  }
  my $fh = Apache::File->new($template) || return;
  local $/ = undef;
  my $plate = <$fh>;
  return bless { 'plate' => $plate,
		 'modified' => (stat $template)[9] }, $class;

}

sub plate { return $_[0]->{'plate'}; }
sub modified { return $_[0]->{'modified'}; }

1;
