package Apache::NavFooter;

##Derived from work by Lincoln Stein in his article
##"A Dynamic Navigation Bar with mod_perl" in
##The Perl Journal, Issue #12, Vol.3, No.4

use strict;
use Apache::Constants qw(:common);
use Apache::File ();
use Apache::URI  ();
use Apache::OutputChain ();
use File::Basename;

use vars qw( @ISA $VERSION );
@ISA = qw(Apache::OutputChain);

my %BARS = ();
my %TB = ();

$VERSION = '0.02';

sub handler {
  my $r = shift;
  Apache::OutputChain::handler($r, __PACKAGE__);
}

sub PRINT {
  my $self = shift;
  my $r = $self->[0];
  my $plate = load_footer($r);

  local $_ = join '', @_;
  s#(<BODY.*?>)#$1\n<TABLE BORDER="0">\n<TR><TD>\n#si;
  s#(</BODY>)#</TD></TR><TR><TD>$plate</TD></TR>$1#si;
  $self->Apache::OutputChain::PRINT($_);
  return OK;
}


sub load_footer {
  my ($r) = @_;
  my $conf_file = $r->server_root_relative($r->dir_config('MyTemplate'));
  my $mod_time;
  if (-e $conf_file) {
    $mod_time = (stat _)[9];
  }
  else {
    $conf_file = '';
    $mod_time = 0;
  }

  return $TB{$conf_file}->template()
    if $TB{$conf_file} && $TB{$conf_file}->modified >= $mod_time;
  #warn "NavBar: plate not cached\n";
  #warn "NavBar plate: No object\n" unless exists $TB{$conf_file};
  $TB{$conf_file} = Apache::NavGraphics::NavTemplate->new($conf_file);
  #warn "NavBar plate: ",$TB{$conf_file}->modified," >= $mod_time\n";
  return $TB{$conf_file}->template();

}

package Apache::NavGraphics::NavTemplate;

sub new {
  my ($class, $templateFile) = @_;
  unless ($templateFile) {
    return bless { 'template' => '',
		   'modified' => 0 }, $class;
  }
  my $fh = Apache::File->new($templateFile) || return;
  my $template = join "\n", <$fh>;
  return bless { 'template' => $template,
		 'modified' => (stat $templateFile)[9] }, $class;

}

sub template { return $_[0]->{'template'}; }
sub modified { return $_[0]->{'modified'}; }

1;
