package Apache::SendFile;

use strict;
use Apache::Constants qw(:response :methods :http);
use Apache::File ();
use Apache::Log ();
use File::Basename;
use vars qw( $VERSION );

$VERSION = '0.04';

sub handler {
    my $r = shift;
    ($r->content_type eq 'text/html') || return DECLINED;
    ($r->filename =~ m/\.html?$/ ) || return DECLINED;

    #warn time(), "\n";
    if ((my $rc = $r->discard_request_body) != OK) {
	return $rc;
    }

    if ($r->method_number == M_INVALID) {
        $r->log->error("Invalid method in request ", $r->the_request);
        return NOT_IMPLEMENTED;
    }

    if ($r->method_number == M_OPTIONS) {
        return DECLINED; #http_core.c:default_handler() will pick this up
    }

    if ($r->method_number == M_PUT) {
        return HTTP_METHOD_NOT_ALLOWED;
    }

    unless (-e $r->finfo) {
	$r->log->error("File does not exist: ", $r->filename);
	return NOT_FOUND;
    }

    if ($r->method_number != M_GET) {
        return HTTP_METHOD_NOT_ALLOWED;
    }

    my $fh = Apache::File->new($r->filename);
    unless ($fh) {
        $r->log->error("file permissions deny server access: ",
                       $r->filename);
        return FORBIDDEN; 
    }   

    ##Let Apache check the file modification times for
    ##the source file, navigation config file and the
    ##templates.
    my $navConf = join '/', $r->document_root(),
			    dirname($r->parsed_uri()->path),
			    'navConf.txt';

    my $template = $r->server_root_relative($r->dir_config('MyTemplate'));
		
    $r->update_mtime();
    foreach ($navConf, $template) {
      next unless -e $_;
      $r->update_mtime((stat _)[9]);
    }

    $r->set_last_modified;
    $r->set_etag;

    if((my $rc = $r->meets_conditions) != OK) {
	return $rc;
    }


    $r->header_out("X-Module-Sender" => __PACKAGE__); 
    $r->send_http_header;

    unless ($r->header_only) {
      local $/ = undef;
      my $data = <$fh>;
      print $data;
    }

    return OK;
}


1;
