package Apache::Try;

use strict;
use Apache::Constants qw(:response :methods :http);
use vars qw( $VERSION );

$VERSION = '0.03';

sub handler {
    my $r = shift;
    $r=$r->filter_register();

    warn join '', "Try: ", $r->filename(),
       ( (-d $r->finfo) ? " is directory\n" : " is file\n");
    return DECLINED;
}


1;

__END__
