#  -*- perl -*-

use strict;
use Test;

require 't/connect.pl';

BEGIN {
  plan tests => 6;
}

my $dbh = Connect::db();

ok($dbh->do(<<';'),'0E0');
create sequence ramona
  minvalue 1
  maxvalue 999999999999999999999999999
  increment by 1
  nocycle
  noorder
  cache 20
  start with 1
;

ok($dbh->do(<<';'),'0E0');
create sequence nadja
  minvalue 3
  maxvalue 11
  increment by 2
  cycle
  order
  nocache
  start with 5
;

ok($dbh->do(<<';'),'0E0');
create table colors (
  id       integer constraint colors_pkey primary key,
  cyan     integer,
  magenta  char(7) not null,
  yellow   dec(11,3),
  black    number(22,0),
  constraint colors_skey unique(cyan, magenta, yellow, black)
)
pctfree 10 pctused 40 initrans 1
;

ok($dbh->do(<<';'),'0E0');
create table pixels (
  x          integer,
  y          integer constraint pixels_y_range check ( 0 <= y and y < 768 ),
  color_id   integer constraint pixels_ref_colors references colors(id)
                     on delete cascade,
  constraint pixels_pkey primary key (x,y),
  constraint pixels_x_range check ( 0 <= x and x < 1024 )
)
pctfree 11 pctused 41 initrans 2
;

ok($dbh->do(<<';'),'0E0');
create view v_pixelcolors
  ( pix_x, pix_y, col_cyan, col_magenta, col_yellow, col_black )
  as select p.x, p.y, c.cyan, c.magenta, c.yellow, c.black
       from pixels p, colors c
       where p.color_id = c.id
  with read only
;


ok($dbh->do(<<';'),'0E0');
create view colours
  as select id, cyan, magenta, yellow, black from colors
  with check option constraint colours_check
;

$dbh->disconnect;
undef $dbh;

exit(0);
