#  -*- perl -*-

use strict;
use Test;
use SQL::Schema::Table::Column;

BEGIN {
  plan tests => 13;
}



{
  eval { SQL::Schema::Table::Column->new(); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Missing required attribute `column_name'");
}



{
  eval { SQL::Schema::Table::Column->new('cloumn_name' => 'foo'); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Unknown attribute `cloumn_name'");
}



{
  eval { SQL::Schema::Table::Column->new('cloumn_name' => 'foo'); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Unknown attribute `cloumn_name'");
}



{
  eval {
    SQL::Schema::Table::Column->new(qw(
      column_name foo
      data_type   char
      data_length x
    ));
  };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Value for `data_length' needs to be an integer");
}



{
  eval {
    SQL::Schema::Table::Column->new(qw(
      column_name foo
      data_type   integer
      nullable    x
    ));
  };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Unsupported value for `nullable'");
}



{
  eval {
    SQL::Schema::Table::Column->new(qw(
      column_name     foo
      data_type       number
      data_length     0
    ));
  };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"attribute `data_length' needs to be a positive value");
}



{
  eval {
    SQL::Schema::Table::Column->new(qw(
      column_name     foo
      data_type       number
      data_precision  -1
    ));
  };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"attribute `data_precision' needs to be a positive value");
}



{
  eval {
    SQL::Schema::Table::Column->new(qw(
      column_name     foo
      data_type       number
      data_scale      1
    ));
  };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok(
    $err,
    "attribute `data_scale' requires `data_length' or `data_precision'"
  );
}



eval {
  ok(
    ref SQL::Schema::Table::Column->new(qw(
          column_name foo
          data_type   integer
        )),
    'SQL::Schema::Table::Column'
  );
};
ok($@||'','');



ok(
  ref SQL::Schema::Table::Column->new(qw(
        column_name foo
        data_type   char
        data_length 17
        nullable    Y
      )),
  'SQL::Schema::Table::Column'
);



ok(
  ref SQL::Schema::Table::Column->new(qw(
        column_name    foo
        data_type      decimal
        data_precision 7
        data_scale     2
        nullable       N
      )),
  'SQL::Schema::Table::Column'
);



ok(
  ref SQL::Schema::Table::Column->new(qw(
        column_name    foo
        data_type      number
        data_precision 7
        data_scale     0
        nullable       N
      )),
  'SQL::Schema::Table::Column'
);



exit(0);
