#  -*- perl -*-

use strict;
use Test;
use SQL::Schema::Table::Column;

require 't/connect.pl';

BEGIN {
  plan tests => 6;
}

my $dbh = Connect::db();



{
  eval { SQL::Schema::Table::Column->select(); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Database handle required by select()");
}



{
  eval { SQL::Schema::Table::Column->select('colors'); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Database handle needs to be a reference");
}



{
  eval { SQL::Schema::Table::Column->select($dbh); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Table name required by select()");
}



{
  eval { SQL::Schema::Table::Column->select($dbh,'colors'); };
  my $err = $@ || '';
  $err =~ s/ at \S+ line \d+\n$//;
  ok($err,"Column name required by select()");
}



{
  my $column = SQL::Schema::Table::Column->select($dbh,'notthere','nocolumn');
  ok(defined($column)?'defined':'undefined','undefined');
}



{
  my $column = SQL::Schema::Table::Column->select($dbh,'colors','cyan');
  ok(ref $column, 'SQL::Schema::Table::Column');
}



$dbh->rollback;
$dbh->disconnect;
undef $dbh;

exit(0);
