#  -*- perl -*-

use strict;
use Test;
use SQL::Schema;

require 't/connect.pl';

BEGIN {
  plan tests => 1;
}

my $dbh = Connect::db();



ok(SQL::Schema->new($dbh)->string,<<'EOS');
create sequence nadja
  minvalue 3
  maxvalue 11
  increment by 2
  cycle
  order
  nocache
  start with 7;

create sequence ramona
  minvalue 1
  maxvalue 999999999999999999999999999
  increment by 1
  nocycle
  noorder
  cache 20
  start with 2;

create table colors (
  id number(22,0) not null,
  cyan number(22,0),
  magenta char(7) not null,
  yellow number(11,3),
  black number(22,0),
constraint colors_pkey primary key (
  id
)
not deferrable initially immediate
enable validate,
constraint colors_skey unique (
  cyan,
  magenta,
  yellow,
  black
)
not deferrable initially immediate
enable validate
)
  pctfree 10
  pctused 40
  initrans 1;

create table pixels (
  x number(22,0) not null,
  y number(22,0) not null,
  color_id number(22,0),
constraint pixels_pkey primary key (
  x,
  y
)
not deferrable initially immediate
enable validate,
constraint pixels_ref_colors foreign key (
  color_id
)
references sql_test.colors (
  id
)
on delete cascade
not deferrable initially immediate
enable validate,
constraint pixels_x_range check ( 0 <= x and x < 1024 )
not deferrable initially immediate
enable validate,
constraint pixels_y_range check ( 0 <= y and y < 768 )
not deferrable initially immediate
enable validate
)
  pctfree 11
  pctused 41
  initrans 2;

create view colours ( id, cyan, magenta, yellow, black )
  as select id, cyan, magenta, yellow, black from colors
  with check option   constraint colours_check;

create view v_pixelcolors ( pix_x, pix_y, col_cyan, col_magenta, col_yellow, col_black )
  as select p.x, p.y, c.cyan, c.magenta, c.yellow, c.black
       from pixels p, colors c
       where p.color_id = c.id
  with read only;
EOS



$dbh->rollback;
$dbh->disconnect;
undef $dbh;

exit(0);
