
using System;
using SharpDoc;

public class ConsoleWriter : IDocWriter {


    public void Write( TypeList list , string[] parameters ) {

	foreach(TypeItem t in list ) {
	    Console.WriteLine();
	    Console.WriteLine();
	    Console.WriteLine("Type --------- ");
	    Console.WriteLine("  Name:                     {0}" , t.Name );
	    Console.WriteLine("  FullName:                 {0}" , t.FullName );
	    
	    Console.WriteLine("  Signature:                {0}" , t.Signature  );
	    Console.WriteLine("  ILASMSignature:           {0}" , t.ILASMSignature  );
	    Console.WriteLine("  MemberOfLibrary:          {0}" , t.MemberOfLibrary );
	    Console.WriteLine("  ThreadingSafetyStatement: {0}..." , t.ThreadingSafetyStatement  );
	    Console.WriteLine("  Base:                     {0}" , t.BaseType );
	    Console.WriteLine("  Interfaces --------");
	    
	    foreach(string interf in t.Interfaces ) {
		Console.WriteLine("     Interface:             {0}" , interf );
	    
	    }
	    
	    Console.WriteLine();
	    Console.WriteLine("  AssemblyInfo ---------       " );
	    Console.WriteLine("    AssemblyName:           {0}" , t.AssemblyInfo.AssemblyName );
	    Console.WriteLine("    AssemblyPublicKey:      {0}" , t.AssemblyInfo.AssemblyPublicKey );
	    Console.WriteLine("    AssemblyVersion:        {0}" , t.AssemblyInfo.AssemblyVersion );
	    Console.WriteLine("    AssemblyCulture:        {0}" , t.AssemblyInfo.AssemblyCulture );
	
	    Console.WriteLine("    Attributes --------");
	    foreach(string attrib in t.AssemblyInfo.Attributes ) {
		Console.WriteLine("      Attribute:            {0}" , attrib );
	    }
	    
	    Console.WriteLine("  Members ---------       " );
	    foreach( MemberItem member in t.Members ) {
		Console.WriteLine("    Member ---------       " );
		Console.WriteLine("      Name:                 {0}" , member.Name );
		Console.WriteLine("      MemberType:           {0}" , member.MemberType );
		Console.WriteLine("      Signature:            {0}" , member.Signature );
		Console.WriteLine("      ILAMSignature:        {0}" , member.ILASMSignature );
		Console.WriteLine("      ReturnType:           {0}" , member.ReturnType );
		
		Console.WriteLine("      Parameters ---------     " );
		foreach( ParameterItem param in member.Parameters ) {
		    Console.WriteLine("        Param:              {0} {1}" , param.Type , param.Name ); 
		}
	    }
	}

    }
    

}
