/*	Authour: Indika M Wickramanayake
	Date: 24th October 2002
	Email: indikamw@hotmail.com
 **/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace ThreadTester
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		public volatile Panel panel1;
		public static Color shapeColor = Color.Blue;
		public ColorDialog c;
		public static int threadCount = 0;
		private System.ComponentModel.Container components = null;
		private Button cmdStart;
		private Button cmdExit;
		private const int shapSize = 15; 
		private volatile Graphics g;
		private System.Windows.Forms.ComboBox comboBox1;
		private System.Windows.Forms.Button cmdColor;
		private System.Windows.Forms.ComboBox comboBoxSpeed;
		private System.Windows.Forms.Label label1;
		// This holds all the threads that are currently alive
		private Hashtable threadHolder = new Hashtable();


        public Form1()
		{	// Required for Windows Form Designer support
			InitializeComponent();
			g = panel1.CreateGraphics();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdExit = new System.Windows.Forms.Button();
			this.cmdStart = new System.Windows.Forms.Button();
			this.panel1 = new System.Windows.Forms.Panel();
			this.comboBox1 = new System.Windows.Forms.ComboBox();
			this.cmdColor = new System.Windows.Forms.Button();
			this.comboBoxSpeed = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// cmdExit
			// 
			this.cmdExit.Location = new System.Drawing.Point(16, 16);
			this.cmdExit.Name = "cmdExit";
			this.cmdExit.Size = new System.Drawing.Size(64, 24);
			this.cmdExit.TabIndex = 1;
			this.cmdExit.Text = "Exit";
			this.cmdExit.Click += new System.EventHandler(this.button1_Click);
			// 
			// cmdStart
			// 
			this.cmdStart.Location = new System.Drawing.Point(96, 16);
			this.cmdStart.Name = "cmdStart";
			this.cmdStart.Size = new System.Drawing.Size(56, 24);
			this.cmdStart.TabIndex = 2;
			this.cmdStart.Text = "Start";
			this.cmdStart.Click += new System.EventHandler(this.button2_Click);
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel1.Location = new System.Drawing.Point(8, 80);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(352, 256);
			this.panel1.TabIndex = 3;
			// 
			// comboBox1
			// 
			this.comboBox1.Items.AddRange(new object[] {
														   "Rectangle",
														   "Circle"});
			this.comboBox1.Location = new System.Drawing.Point(240, 16);
			this.comboBox1.Name = "comboBox1";
			this.comboBox1.Size = new System.Drawing.Size(112, 21);
			this.comboBox1.TabIndex = 4;
			this.comboBox1.Text = "Rectangle";
			this.comboBox1.SelectedIndexChanged += new System.EventHandler(this.comboBox1_SelectedIndexChanged);
			// 
			// cmdColor
			// 
			this.cmdColor.Location = new System.Drawing.Point(168, 16);
			this.cmdColor.Name = "cmdColor";
			this.cmdColor.Size = new System.Drawing.Size(56, 24);
			this.cmdColor.TabIndex = 5;
			this.cmdColor.Text = "Color";
			this.cmdColor.Click += new System.EventHandler(this.cmdColor_Click);
			// 
			// comboBoxSpeed
			// 
			this.comboBoxSpeed.Items.AddRange(new object[] {
															   "5",
															   "10",
															   "15",
															   "20",
															   "30",
															   "50",
															   "75",
															   "100",
															   "200",
															   "300",
															   "500"});
			this.comboBoxSpeed.Location = new System.Drawing.Point(240, 48);
			this.comboBoxSpeed.Name = "comboBoxSpeed";
			this.comboBoxSpeed.Size = new System.Drawing.Size(112, 21);
			this.comboBoxSpeed.TabIndex = 6;
			this.comboBoxSpeed.Text = "5";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(184, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 24);
			this.label1.TabIndex = 7;
			this.label1.Text = "Speed:";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(368, 349);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label1,
																		  this.comboBoxSpeed,
																		  this.cmdColor,
																		  this.comboBox1,
																		  this.panel1,
																		  this.cmdStart,
																		  this.cmdExit});
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{ Application.Run(new Form1()); }

		private void Form1_Load(object sender, System.EventArgs e)
		{		}


		private void StartThread()
		{
			/* Create the shape object */
			Shapes shapes;
			if(comboBox1.Text.Equals("Rectangle"))
			shapes =  new Rectangle(0,0,shapSize,shapSize,shapeColor,this,Convert.ToInt32(comboBoxSpeed.Text.Trim()));
			else if(comboBox1.Text.Equals("Circle"))
			shapes =  new Circle(0,0,shapSize,shapSize,shapeColor,this,Convert.ToInt32(comboBoxSpeed.Text.Trim())); 
			/**The line below is not necessary , but if you want to add more shapes this will help*/
			else
			shapes =  new Rectangle(0,0,shapSize,shapSize,shapeColor,this,Convert.ToInt32(comboBoxSpeed.Text.Trim()));
		
			while(true)
			{	try
				{ shapes.paint(g); 	}
					
				catch(Exception e1)
				{	Console.WriteLine("Exception in Form1 whileloop >> "+e1);
					break;	 
				}
			}
		}

		/* Everytime start button clicks, start a new thread that handles
		 * the specific shape
		 * */
		private void button2_Click(object sender, System.EventArgs e)
		{	Thread t = new Thread(new ThreadStart(StartThread));
			threadHolder.Add(threadCount++,t);
			/* Assign a name for each thread (but it's not necessary) */
			t.Name = "Thread ID: "+threadCount;
			t.IsBackground  = true;
			t.Start();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			/* Abort all the threads that are currently alive */
			foreach(Thread t in threadHolder.Values)
			{  if(t != null && t.IsAlive)
				   t.Abort();
			}
			Form1.ActiveForm.Close();	
		}
		
		private void cmdColor_Click(object sender, System.EventArgs e)
		{	c = new ColorDialog();
			c.ShowDialog();
			shapeColor = c.Color;
		}

		private void comboBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{		}

	}
}
