/* This program creates a transparent window (using the XShape
* extension) and draw four white (opaque) squares in each corner of
* the window
*/

// THIS WORK

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <unistd.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>

/* size of the window */
#define W_WIDTH 640
#define W_HEIGHT 480

/* size of the four rectangles that will be drawn in the window */
#define R_WIDTH 80
#define R_HEIGHT 60

/* the four rectangles that will be drawn: one in each corner of the
* window */
XRectangle rectangles[4] =
{
{ 0, 0, R_WIDTH, R_HEIGHT },
{ 0, W_HEIGHT-R_HEIGHT, R_WIDTH, R_HEIGHT },
{ W_WIDTH-R_WIDTH, W_HEIGHT-R_HEIGHT, R_WIDTH, R_HEIGHT },
{ W_WIDTH-R_WIDTH, 0, R_WIDTH, R_HEIGHT }
};

int main(int argc, char **argv)
{
Display *dpy = NULL;
Window w;
Pixmap pmap;
GC shape_gc;
GC win_gc;
XGCValues xgcv;
char* display_string = NULL;
int event_base = 0; /* not used in this example */
int error_base = 0; /* not used in this example */
int run = 1; /* loop control variable */

/* open the display */
display_string = getenv("DISPLAY");
if (!(dpy = XOpenDisplay(display_string))) {
fprintf(stderr, "can't open display '%s'\n",
(display_string ? display_string : "NULL"));
return EXIT_FAILURE;
}

/* ask the server if it supports XShape; if not, this program


* isn't useful! */
if (False == XShapeQueryExtension(dpy, &event_base, &error_base)) {

fprintf(stderr, "display '%s' does not support XShape\n",


(display_string ? display_string : "NULL"));
return EXIT_FAILURE;
}

/* create the window */


w = XCreateWindow(dpy, DefaultRootWindow(dpy), 0, 0, W_WIDTH,
W_HEIGHT, 0, CopyFromParent, InputOutput,
CopyFromParent, 0, NULL);

/* create a graphics context for drawing on the window */
xgcv.foreground = WhitePixel(dpy, DefaultScreen(dpy));
xgcv.line_width = 1;
xgcv.line_style = LineSolid;
win_gc = XCreateGC(dpy, w,
GCForeground | GCLineWidth | GCLineStyle, &xgcv);

/* create the pixmap that we'll use for shaping the window */
pmap = XCreatePixmap(dpy, w, W_WIDTH, W_HEIGHT, 1);

/* create a graphics context for drawing on the pixmap */
shape_gc = XCreateGC(dpy, pmap, 0, &xgcv);

/* shape the window: first blank everything */
XSetForeground(dpy, shape_gc, 0);
XFillRectangle(dpy, pmap, shape_gc, 0, 0, W_WIDTH,
W_HEIGHT);

/* shape the window: now "unblank" everything where we want to


* draw */
XSetForeground(dpy, shape_gc, 1);
XDrawRectangles(dpy, pmap, shape_gc, rectangles, 4);
XFillRectangles(dpy, pmap, shape_gc, rectangles, 4);

XShapeCombineMask (dpy, w, ShapeBounding, 0, 0, pmap, ShapeSet);
XFreePixmap(dpy, pmap);

/* register events: ExposureMask for re-drawing, ButtonPressMask
* to capture mouse button press events */
XSelectInput(dpy, w, ButtonPressMask | ExposureMask);

XMapWindow(dpy, w);
XSync(dpy, False);

while (run) {
XEvent xe;
XNextEvent(dpy, &xe);
switch (xe.type) {
case Expose:
printf("Expose\n");
/* whenever we get an expose, draw the rectangles */
XSetForeground(dpy, win_gc, WhitePixel(dpy,
DefaultScreen(dpy)));
XDrawRectangles(dpy, w, win_gc, rectangles, 4);
XFillRectangles(dpy, w, win_gc, rectangles, 4);

break;


case ButtonPress: /* quit if a button is pressed */
printf("ButtonPress\n");
run = 0;
break;
default:
printf("Caught event %i\n", xe.type);
}
}

XDestroyWindow(dpy, w);
XCloseDisplay(dpy);

return EXIT_SUCCESS;
}
