#!/bin/sh
echo -n "clean..."
make distclean > /dev/null 2>&1
rm -f *.out configure.lineno
echo -n "configure..."
./configure --enable-manuals --enable-mibs --enable-mib-loading \
 --enable-ucd-snmp-compatibility \
 --with-openssl --without-rpm \
 --with-mib-modules="host agentx" \
  --with-defaults \
  > cfg.out 2>&1
 

RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror cfg.out
  echo "**FAIL** configure"
  exit 1
fi

echo -n "make..."
make > make.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror make.out
  echo "**FAIL** make"
  exit 1
fi

echo -n "make test..."
make test > maketest.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror maketest.out
  echo "**FAIL** make test"
  exit 1
fi

echo -n "make install..."
make install > inst.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror inst.out
  echo "**FAIL** make install"
  exit 1
fi

echo "Done."

exit 0
 --with-out-mib-modules="host/hr_storage host/hr_swrun" \

"make test" fails if next line is added to configure
31:testing AgentX trap sending support...FAIL
  --with-mib-modules="examples/example" \

snmpwalk halts on second IP6 TCP object
 because OID is not lexicographically increasing.
  --enable-ipv6 --with-transports="TCPIPv6 UDPIPv6" \
