
/****************************************************************************/
/*                                                                          */
/*   COPYRIGHT (c) 1999 BY COMPAQ COMPUTER CORPORATION                      */
/*   ALL RIGHTS RESERVED.                                                   */
/*                                                                          */
/*   THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED  */
/*   ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE  */
/*   INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER  */
/*   COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  */
/*   OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY  */
/*   TRANSFERRED.                                                           */
/*                                                                          */
/*   THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE  */
/*   AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY COMPAQ COMPUTER    */
/*   CORPORATION.                                                           */
/*                                                                          */
/*   COMPAQ ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS   */
/*   SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY COMPAQ.                 */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          Extensible SNMP agent of Digital Unix for DECss7
 **
 **   MODULE NAME:       agt_decss7_main.c
 **
 **   DESCRIPTION:       main program of the Extensible SNMP agent
 **                      of digital Unix
 **
 **   AUTHORS:           H. Wassifi
 **
 **   CREATION DATE:
 **
 **   MODIFICATION HISTORY:
 ************************************************************************/

/* ----------------- Include files ----------------- */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <stdarg.h>
#include <sys/types.h>

/*
 *  UCD-SNMP include files
 */
#include <ucd-snmp/ucd-snmp-config.h>
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#include <ucd-snmp/ucd-snmp-includes.h>
#include <ucd-snmp/ucd-snmp-agent-includes.h>

/*
 * Use NET-SNMP with UCD_COMPATIBLE mode
 */
#ifdef UCD_COMPATIBLE
#define DS_APPLICATION_ID		NETSNMP_DS_APPLICATION_ID
#define DS_AGENT_ROLE                   NETSNMP_DS_AGENT_ROLE
#endif

#define ESNMP_LIB_NOTOK -5
#define ESNMP_LIB_OK     0

/* ----------------- Data definitions ----------------- */

/*
 * trapParam_variables table indexes
 */
enum trapParam_index {
TRAPTIME,                                   /* 0 */
TRAPTYPE,                                   /* 1 */
TRAPENTITYNAME,                             /* 2 */
TRAPNODENAME,                               /* 3 */
TRAPPROCESSNAME,                            /* 4 */
TRAPCAUSE,                                  /* 5 */
TRAPSEVERITY,                               /* 6 */
TRAPTEXT,                                   /* 7 */
TRAPSPECIFICPROBLEM,                        /* 8 */
TRAPPLATFORMID                              /* 9 */
};


/*
 * Decss7 global indexes
 */
enum decss7_variables {
        I_trapTime                                ,    /* 0 */
        I_trapType                                ,    /* 1 */
        I_trapEntityName                          ,    /* 2 */
        I_trapNodeName                            ,    /* 3 */
        I_trapProcessName                         ,    /* 4 */
        I_trapCause                               ,    /* 5 */
        I_trapSeverity                            ,    /* 6 */
        I_trapText                                ,    /* 7 */
        I_trapSpecificProblem                     ,    /* 8 */
        I_trapPlatformId                          ,    /* 9 */ 
        MAX_DECSS7_TBL_VARIABLES
};


/* MIB UCD Object */
typedef struct _ucdobject {
	oid*              top_oid;      /* Top oid of the ucdobject base in binary integer array form */
	int               top_oid_len;  /* number of elements in top oid */
        struct variable4* variables;    /* pointer to an array of ucdobject variable4 */
        int               first;         /* integer id of first item in ucdobject */
} UCDOBJECT;


/* MIB Subtree */
typedef struct _subtree {
        char      *name;                  /* name of subtree in text form */
        UCDOBJECT *object_tbl;            /* pointer to an array of subtree ucdobjects */
        int       last;                   /* integer id of last item in subtree */
} SUBTREE;


FindVarMethod   var_trapParam;

unsigned char  *
var_trapParam(struct variable *vp,
              oid * name,
              size_t * length,
              int exact, size_t * var_len, WriteMethod ** write_method)
{
  return NULL;
}

char GPS_agent_name[256];

/*extern OBJECT objects[];*/

oid trapParam_variables_oid[] = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90 };

struct variable4 trapParam_variables[] = {
    {TRAPTIME, ASN_OCTET_STR, RONLY, var_trapParam, 1, {1}},
    {TRAPTYPE, ASN_INTEGER, RONLY, var_trapParam, 1, {2}},
    {TRAPENTITYNAME, ASN_OCTET_STR, RONLY, var_trapParam, 1, {3}},
    {TRAPNODENAME, ASN_OCTET_STR, RONLY, var_trapParam, 1, {4}},
    {TRAPPROCESSNAME, ASN_OCTET_STR, RONLY, var_trapParam, 1, {5}},
    {TRAPCAUSE, ASN_OCTET_STR, RONLY, var_trapParam, 1, {6}},
    {TRAPSEVERITY, ASN_INTEGER, RONLY, var_trapParam, 1, {7}},
    {TRAPTEXT, ASN_OCTET_STR, RONLY, var_trapParam, 1, {8}},
    {TRAPSPECIFICPROBLEM, ASN_INTEGER, RONLY, var_trapParam, 1, {9}},
    {TRAPPLATFORMID, ASN_OCTET_STR, RONLY, var_trapParam, 1, {99}}
};
UCDOBJECT objects[] = {
{&trapParam_variables_oid[0], 13, &trapParam_variables[0], 0}
};

SUBTREE decss7_subtree = {"signaling", &objects[0], MAX_DECSS7_TBL_VARIABLES};

#define REG_MIB(status, descr, var, vartype, theoid)                      \
 status = register_mib(descr, (struct variable *)var , sizeof(struct vartype), \
          sizeof(var)/sizeof(struct vartype),theoid, sizeof(theoid)/sizeof(oid)) ; \
 if (status == MIB_REGISTRATION_FAILED) return status;


int
register_decss7 (void)
{
  int VI_rc = 0;
  REG_MIB(VI_rc, "trapParam", trapParam_variables, variable4, trapParam_variables_oid);
  return ESNMP_LIB_OK;
}

/*
 * FACILITY:    
 *
 *      esnmp_init
 *
 * ABSTRACT:
 *
 *      Stub for Linux: this function initializes the agent library.
 *
 * COMMENTS:
 *
 *      Parameter socket is not used here.
 *
 * FORMAL PARAMETERS:
 *
 *  int      *AI_socket(OUT)
 *  char     *AP_subagent_identifier (IN) 
 *
 * RETURN VALUE:
 *
 *  ESNMP_LIB_OK  if success, otherwise:
 *   ESNMP_LIB_NOTOK if failed to initialize the sub agent
 *   or ESNMP_LIB_NO_CONNECTION if snmpd daemon is not running
 *
 * AUTHOR:
 *
 *      Laure Catrou
 *
 * MODIFICATION HISTORY:
 * 
 *      31-Oct-2003   SPP Development Team
 *                    Linux Porting
 *
 */
int esnmp_init(int *AI_socket,char *AP_subagent_identifier)
{
    // initializes the sub agent 
    if ( 0 != init_agent(AP_subagent_identifier))
    { 
      return ESNMP_LIB_NOTOK; 
    }
    // end with other initializations
    init_snmp(AP_subagent_identifier);

    return ESNMP_LIB_OK;
}

/* ----------------- Routines definitions ----------------- */

/*
   **
   **  ABSTRACT:
   **
   ** This routine does the following:
   **     3)  calls esnmp_init() to initialize and send the open.
   **         Calls esnmp_register() for each subtree to be supported
   **  when the response to the OPEN is received.
 
   ** From these routines I could get the following status codes:
   **    0) ESNMP_LIB_OK              - continue, everything is fine.
   **   -1) ESNMP_LIB_NO_CONNECTION   - Can't send OPEN to Master Agent, restart.
   **        -2) ESNMP_LIB_BAD_REG         - Registration error.
   **   -3) ESNMP_LIB_CLOSE           - Received a CLOSE message. restart.
   **   -4) ESNMP_LIB_LOST_CONNECTION - lost connection with Master Agent, restart.
   **   -5) ESNMP_LIB_NOTOK           - negative response.
   **
   **
   **  FORMAL PARAMETERS:
   **
   **      USAGE:  decss7_mib [-trace] [-f profile_filename][-p platform_id ...]
   **  -trace              : show all trace messages
   **              -f profile_filename : MIB translator profile file name
   **              -p platform_id      : platform to manage
   **
   **
   **  RETURN VALUE:
   **
   **      No value return.
   **
   **  SIDE EFFECTS:
   **
   **      None.
   **
   **
 */

#define MM_ESNMP_LOG_TRACE printf

/* EVENT_REPORT */
/*    SS7 */
/* 	class_name = 239 // SS7_K_M3UA_ASSO */
/* 	event_id = 213 // SS7_K_M3UA_ASSO_SSNMRCV */
/*    SNMP */
/* 	platform_id */
/* 	timestamp */
/* 	entity_name */
/* 	severity = s_Warning */
/* 	cause = "SSNM message received" */
/* 	type = INFO_ALARM */
/* 	trap_id = 3414 // m3uaAssociationSsnmRcv  */
/* 	; */
int
main(
    int     argc,
    char**  argv)
{
  int nb_trap = 1;
  int i;
  struct timeval begin_time, end_time, diff_time;

  int VI_rc;
  int VI_subsocket = 0;

  int VI_oid_len = 0;
  int AI_specific_trap = 3414;

  long severity = 2;    /* as an example */
  long evtType  = 3415; /* as an example */
  long specific = 5;    /* as an example */
  int var_list_len = sizeof(struct variable_list);
  oid time_oid[]     = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 1 };
  oid entname_oid[]  = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 2 };
  oid cause_oid[]    = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 3 };
  oid severity_oid[] = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 4 };
  oid type_oid[]     = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 5 };
  oid arg_oid[]      = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 6 };
  oid platform_oid[] = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 7 };
  oid spec_oid[]     = { 1, 3, 6, 1, 4, 1, 11, 2, 29, 2, 6, 20, 90, 1, 8 };

  struct variable_list VP_time_var, VP_entname_var, VP_cause_var, VP_severity_var, 
  VP_type_var, VP_arg_var, VP_platform_var, VP_spec_var;

  printf("argc = %i argv[0] = %s, argv[1] = %s\n", argc, argv[0], argv[1] );
  if (argc > 1)
  {
    nb_trap = atoi(argv[1]);
  }

  sprintf(GPS_agent_name,"%s",argv[0]);
  ds_set_boolean(DS_APPLICATION_ID, DS_AGENT_ROLE, 1);

  MM_ESNMP_LOG_TRACE("Initialize and send the OPEN\n");

  /*
   * Initialize and send the OPEN
   */
  VI_rc = esnmp_init(&VI_subsocket, argv[0]);
  if (VI_rc != ESNMP_LIB_OK) {
    MM_ESNMP_LOG_TRACE("main: esnmp_init failed\n");
    exit(1);
  }
  MM_ESNMP_LOG_TRACE("Register the MIB.\n");

  /*
   * Register the MIB.
   */
  VI_rc = register_decss7();

  if (VI_rc != ESNMP_LIB_OK) {
    MM_ESNMP_LOG_TRACE("main: Could not register the subtree\n");
    exit(1);
  }

  MM_ESNMP_LOG_TRACE("Build the trap\n");

  /*
   * fill the timestamp field of the varbind.
   */
  memset(&VP_time_var, 0, var_list_len);
  VP_time_var.next_variable = &VP_entname_var;
  VP_time_var.name = time_oid;
  VP_time_var.name_length = 15;
  VP_time_var.type = ASN_OCTET_STR;
  VP_time_var.val.string = "10-jun-2005 10:53:31.00";
  VP_time_var.val_len = strlen(VP_time_var.val.string)+1;

  /*
   * fill the entity_name field of the varbind.
   */
  memset(&VP_entname_var, 0, var_list_len);
  VP_entname_var.next_variable = &VP_cause_var;
  VP_entname_var.name = entname_oid;
  VP_entname_var.name_length = 15;
  VP_entname_var.type = ASN_OCTET_STR;
  VP_entname_var.val.string = "FEP_SUBSYSTEM toto";
  VP_entname_var.val_len = strlen(VP_entname_var.val.string)+1;

  /*
   * fill the cause field of the varbind.
   */
  memset(&VP_cause_var, 0, var_list_len);
  VP_cause_var.next_variable = &VP_severity_var;
  VP_cause_var.name = cause_oid;
  VP_cause_var.name_length = 15;
  VP_cause_var.type = ASN_OCTET_STR;
  VP_cause_var.val.string = "Too many calls.";
  VP_cause_var.val_len = strlen(VP_cause_var.val.string)+1;

  /*
   * fill the severity field of the varbind.
   */
  memset(&VP_severity_var, 0, var_list_len);
  VP_severity_var.next_variable = &VP_type_var;
  VP_severity_var.name = severity_oid;
  VP_severity_var.name_length = 15;
  VP_severity_var.type = ASN_INTEGER;
  VP_severity_var.val.integer = &severity;
  VP_severity_var.val_len = sizeof(long);

  /*
   * fill the type field of the varbind.
   */
  memset(&VP_type_var, 0, var_list_len);
  VP_type_var.next_variable = &VP_arg_var;
  VP_type_var.name = type_oid;
  VP_type_var.name_length = 15;
  VP_type_var.type = ASN_INTEGER;
  VP_type_var.val.integer = &evtType;
  VP_type_var.val_len = sizeof(long);

  /*
   * fill the arg field of the varbind.
   */
  memset(&VP_arg_var, 0, var_list_len);
  VP_arg_var.next_variable = &VP_platform_var;
  VP_arg_var.name = arg_oid;
  VP_arg_var.name_length = 15;
  VP_arg_var.type = ASN_OCTET_STR;
  VP_arg_var.val.string = "Because of too many callers";
  VP_arg_var.val_len = strlen(VP_arg_var.val.string)+1;


  /*
   * fill the Platform_id field of the varbind.
   */
  memset(&VP_platform_var, 0, var_list_len);
  VP_platform_var.next_variable = &VP_spec_var;
  VP_platform_var.name = platform_oid;
  VP_platform_var.name_length = 15;
  VP_platform_var.type = ASN_OCTET_STR;
  VP_platform_var.val.string = "A";
  VP_platform_var.val_len = strlen(VP_platform_var.val.string)+1;

  /*
   * fill the specific fields of the varbind.
   */
  memset(&VP_spec_var, 0, var_list_len);
  VP_spec_var.next_variable = NULL;
  VP_spec_var.name = spec_oid;
  VP_spec_var.name_length = 15;
  VP_spec_var.type = ASN_INTEGER;
  VP_spec_var.val.integer = &specific;
  VP_spec_var.val_len = sizeof(long);

  MM_ESNMP_LOG_TRACE("MAIN LOOP\n");


  /* MAIN LOOP */
  while(1) 
  {
    gettimeofday(&begin_time, NULL);
    for ( i = 0; i< nb_trap; i++)
      {
        /* Faire ce qui doit etre fait : i.e. envoyer des traps */

        send_enterprise_trap_vars( 6,
                                   AI_specific_trap,
                                   trapParam_variables_oid,
                                   13, /* Do not use NELEM(VA_enterprise_oid) ! */
                                   &VP_time_var );

      } /* end while(1) */
    gettimeofday(&end_time, NULL);
    diff_time.tv_sec = 0;
    diff_time.tv_usec = 1000000 -(end_time.tv_usec - begin_time.tv_usec);
    printf("begin_time.tv_sec = %u, end_time.tv_sec = %u nb_trap sent = %i\n",begin_time.tv_sec, end_time.tv_sec, nb_trap );
    select(0, NULL,NULL,NULL, &diff_time);
  }
  return (0);
}
