#!/usr/bin/perl
# minimal embedded perl agent

my $regat = '.1.3.6.1.4.1.8872.9999.9999'; # netSnmpPlayPen
my $myoid = $regat . ".1.0"; # the hello world OID

use NetSNMP::OID qw(:all);
use NetSNMP::agent qw(:all);
use NetSNMP::ASN qw(:all);
use SNMP;

my $regoid = new NetSNMP::OID($regat);
$agent->register("hello", $regoid, \&my_snmp_handler);

sub my_snmp_handler {
  my ($handler, $registration_info, $request_info, $requests) = @_;
  for(my $request = $requests; $request; $request = $request->next()) {
    if ($request_info->getMode() == MODE_GET) {
      if ($request->getOID() == new NetSNMP::OID($myoid)) {
        $request->setValue(ASN_OCTET_STR, "hello world");
        last;
      }
    }
  }
}
