/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.67.2.1 $ of : mfd-interface.m2c,v $ 
 *
 * $Id:$
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "CCliCtrTable.h"


#include <net-snmp/agent/table_container.h>
#include <net-snmp/library/container.h>

#include "CCliCtrTable_interface.h"

#include <ctype.h>

/**********************************************************************
 **********************************************************************
 ***
 *** Table CCliCtrTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * SNDA-SNMP-MIB::CCliCtrTable is subid 1 of cliCtr.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.2021.13.5243.1.2.1, length: 12
 */
typedef struct CCliCtrTable_interface_ctx_s {

    netsnmp_container *container;
    netsnmp_cache  *cache;

    CCliCtrTable_registration *user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

    u_int           table_dirty;

} CCliCtrTable_interface_ctx;

static CCliCtrTable_interface_ctx CCliCtrTable_if_ctx;

static void     _CCliCtrTable_container_init(CCliCtrTable_interface_ctx *
                                             if_ctx);
static void     _CCliCtrTable_container_shutdown(CCliCtrTable_interface_ctx
                                                 * if_ctx);


netsnmp_container *
CCliCtrTable_container_get(void)
{
    return CCliCtrTable_if_ctx.container;
}

CCliCtrTable_registration *
CCliCtrTable_registration_get(void)
{
    return CCliCtrTable_if_ctx.user_ctx;
}

CCliCtrTable_registration *
CCliCtrTable_registration_set(CCliCtrTable_registration * newreg)
{
    CCliCtrTable_registration *old = CCliCtrTable_if_ctx.user_ctx;
    CCliCtrTable_if_ctx.user_ctx = newreg;
    return old;
}

int
CCliCtrTable_container_size(void)
{
    return CONTAINER_SIZE(CCliCtrTable_if_ctx.container);
}

u_int
CCliCtrTable_dirty_get(void)
{
    return CCliCtrTable_if_ctx.table_dirty;
}

void
CCliCtrTable_dirty_set(u_int status)
{
    DEBUGMSGTL(("CCliCtrTable:CCliCtrTable_dirty_set",
                "called. was %d, now %d\n",
                CCliCtrTable_if_ctx.table_dirty, status));
    CCliCtrTable_if_ctx.table_dirty = status;
}

/*
 * mfd multiplexer modes
 */
static Netsnmp_Node_Handler _mfd_CCliCtrTable_pre_request;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_post_request;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_object_lookup;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_get_values;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_check_objects;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_undo_setup;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_set_values;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_undo_cleanup;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_undo_values;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_commit;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_undo_commit;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_irreversible_commit;
static Netsnmp_Node_Handler _mfd_CCliCtrTable_check_dependencies;

NETSNMP_STATIC_INLINE int _CCliCtrTable_undo_column(CCliCtrTable_rowreq_ctx
                                                    * rowreq_ctx,
                                                    netsnmp_variable_list *
                                                    var, int column);

NETSNMP_STATIC_INLINE int
_CCliCtrTable_check_indexes(CCliCtrTable_rowreq_ctx * rowreq_ctx);

CCliCtrTable_data *CCliCtrTable_allocate_data(void);

/**
 * @internal
 * Initialize the table CCliCtrTable 
 *    (Define its contents and how it's structured)
 */
void
_CCliCtrTable_initialize_interface(CCliCtrTable_registration * reg_ptr,
                                   u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &CCliCtrTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info =
        &CCliCtrTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_initialize_interface",
                "called\n"));


    /*************************************************
     *
     * save interface context for CCliCtrTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_IPADDRESS,
                                                 /** index: SrvIp4CliCtr */
                                     ASN_INTEGER,
                                               /** index: SrvPort4CliCtr */
                                     ASN_IPADDRESS,
                                                 /** index: GsIp4CliCtr */
                                     ASN_INTEGER,
                                               /** index: GsPort4CliCtr */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrival. 
     */
    tbl_info->min_column = CCLICTRTABLE_MIN_COL;
    tbl_info->max_column = CCLICTRTABLE_MAX_COL;

    /*
     * save users context
     */
    CCliCtrTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    CCliCtrTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _CCliCtrTable_container_init(&CCliCtrTable_if_ctx);
    if (NULL == CCliCtrTable_if_ctx.container) {
        snmp_log(LOG_ERR,
                 "could not initialize container for CCliCtrTable\n");
        return;
    }

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup = _mfd_CCliCtrTable_object_lookup;
    access_multiplexer->get_values = _mfd_CCliCtrTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_CCliCtrTable_pre_request;
    access_multiplexer->post_request = _mfd_CCliCtrTable_post_request;


    /*
     * REQUIRED wrappers for set request handling
     */
    access_multiplexer->object_syntax_checks =
        _mfd_CCliCtrTable_check_objects;
    access_multiplexer->undo_setup = _mfd_CCliCtrTable_undo_setup;
    access_multiplexer->undo_cleanup = _mfd_CCliCtrTable_undo_cleanup;
    access_multiplexer->set_values = _mfd_CCliCtrTable_set_values;
    access_multiplexer->undo_sets = _mfd_CCliCtrTable_undo_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->commit = _mfd_CCliCtrTable_commit;
    access_multiplexer->undo_commit = _mfd_CCliCtrTable_undo_commit;
    access_multiplexer->irreversible_commit =
        _mfd_CCliCtrTable_irreversible_commit;

    /*
     * REQUIRED for tables with dependencies
     */
    access_multiplexer->consistency_checks =
        _mfd_CCliCtrTable_check_dependencies;

    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("CCliCtrTable:init_CCliCtrTable",
                "Registering CCliCtrTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("CCliCtrTable", handler,
                                            CCliCtrTable_oid,
                                            CCliCtrTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
                                            HANDLER_CAN_RWRITE);
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table CCliCtrTable\n");
        return;
    }
    reginfo->my_reg_void = &CCliCtrTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            CCliCtrTable_if_ctx.container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject cache helper
     */
    if (NULL != CCliCtrTable_if_ctx.cache) {
        handler = netsnmp_cache_handler_get(CCliCtrTable_if_ctx.cache);
        netsnmp_inject_handler(reginfo, handler);
    }

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);

    /*
     * register config/persistence callbacks
     */
    CCliCtrTable_container_init_persistence(CCliCtrTable_if_ctx.container);

}                               /* _CCliCtrTable_initialize_interface */

/**
 * @internal
 * Shutdown the table CCliCtrTable
 */
void
_CCliCtrTable_shutdown_interface(CCliCtrTable_registration * reg_ptr)
{
    /*
     * shutdown the container
     */
    _CCliCtrTable_container_shutdown(&CCliCtrTable_if_ctx);
}

void
CCliCtrTable_valid_columns_set(netsnmp_column_info *vc)
{
    CCliCtrTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* CCliCtrTable_valid_columns_set */

/**
 * @internal
 * convert the index component stored in the context to an oid
 */
int
CCliCtrTable_index_to_oid(netsnmp_index * oid_idx,
                          CCliCtrTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_SrvIp4CliCtr;
    /*
     * SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_SrvPort4CliCtr;
    /*
     * GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_GsIp4CliCtr;
    /*
     * GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_GsPort4CliCtr;

    /*
     * set up varbinds
     */
    memset(&var_SrvIp4CliCtr, 0x00, sizeof(var_SrvIp4CliCtr));
    var_SrvIp4CliCtr.type = ASN_IPADDRESS;
    memset(&var_SrvPort4CliCtr, 0x00, sizeof(var_SrvPort4CliCtr));
    var_SrvPort4CliCtr.type = ASN_INTEGER;
    memset(&var_GsIp4CliCtr, 0x00, sizeof(var_GsIp4CliCtr));
    var_GsIp4CliCtr.type = ASN_IPADDRESS;
    memset(&var_GsPort4CliCtr, 0x00, sizeof(var_GsPort4CliCtr));
    var_GsPort4CliCtr.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_SrvIp4CliCtr.next_variable = &var_SrvPort4CliCtr;
    var_SrvPort4CliCtr.next_variable = &var_GsIp4CliCtr;
    var_GsIp4CliCtr.next_variable = &var_GsPort4CliCtr;
    var_GsPort4CliCtr.next_variable = NULL;


    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_index_to_oid",
                "called\n"));

    /*
     * SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    snmp_set_var_value(&var_SrvIp4CliCtr,
                       (u_char *) & mib_idx->SrvIp4CliCtr,
                       sizeof(mib_idx->SrvIp4CliCtr));

    /*
     * SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    snmp_set_var_value(&var_SrvPort4CliCtr,
                       (u_char *) & mib_idx->SrvPort4CliCtr,
                       sizeof(mib_idx->SrvPort4CliCtr));

    /*
     * GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    snmp_set_var_value(&var_GsIp4CliCtr, (u_char *) & mib_idx->GsIp4CliCtr,
                       sizeof(mib_idx->GsIp4CliCtr));

    /*
     * GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    snmp_set_var_value(&var_GsPort4CliCtr,
                       (u_char *) & mib_idx->GsPort4CliCtr,
                       sizeof(mib_idx->GsPort4CliCtr));


    err = build_oid_noalloc(oid_idx->oids, oid_idx->len, &oid_idx->len,
                            NULL, 0, &var_SrvIp4CliCtr);
    if (err)
        snmp_log(LOG_ERR, "error %d converting index to oid\n", err);

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_SrvIp4CliCtr);

    return err;
}                               /* CCliCtrTable_index_to_oid */

/**
 * extract CCliCtrTable indexes from a netsnmp_index
 *
 * @retval SNMP_ERR_NOERROR  : no error
 * @retval SNMP_ERR_GENERR   : error
 */
int
CCliCtrTable_index_from_oid(netsnmp_index * oid_idx,
                            CCliCtrTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_SrvIp4CliCtr;
    /*
     * SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_SrvPort4CliCtr;
    /*
     * GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_GsIp4CliCtr;
    /*
     * GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h
     */
    netsnmp_variable_list var_GsPort4CliCtr;

    /*
     * set up varbinds
     */
    memset(&var_SrvIp4CliCtr, 0x00, sizeof(var_SrvIp4CliCtr));
    var_SrvIp4CliCtr.type = ASN_IPADDRESS;
    memset(&var_SrvPort4CliCtr, 0x00, sizeof(var_SrvPort4CliCtr));
    var_SrvPort4CliCtr.type = ASN_INTEGER;
    memset(&var_GsIp4CliCtr, 0x00, sizeof(var_GsIp4CliCtr));
    var_GsIp4CliCtr.type = ASN_IPADDRESS;
    memset(&var_GsPort4CliCtr, 0x00, sizeof(var_GsPort4CliCtr));
    var_GsPort4CliCtr.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_SrvIp4CliCtr.next_variable = &var_SrvPort4CliCtr;
    var_SrvPort4CliCtr.next_variable = &var_GsIp4CliCtr;
    var_GsIp4CliCtr.next_variable = &var_GsPort4CliCtr;
    var_GsPort4CliCtr.next_variable = NULL;


    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_index_from_oid",
                "called\n"));

    /*
     * parse the oid into the individual index components
     */
    err = parse_oid_indexes(oid_idx->oids, oid_idx->len,
                            &var_SrvIp4CliCtr);
    if (err == SNMP_ERR_NOERROR) {
        /*
         * copy out values
         */
        mib_idx->SrvIp4CliCtr = *((u_long *) var_SrvIp4CliCtr.val.string);
        mib_idx->SrvPort4CliCtr =
            *((long *) var_SrvPort4CliCtr.val.string);
        mib_idx->GsIp4CliCtr = *((u_long *) var_GsIp4CliCtr.val.string);
        mib_idx->GsPort4CliCtr = *((long *) var_GsPort4CliCtr.val.string);


    }

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_SrvIp4CliCtr);

    return err;
}                               /* CCliCtrTable_index_from_oid */


/*
 * CCliCtrTable_allocate_data
 *
 * Purpose: create new CCliCtrTable_data.
 */
CCliCtrTable_data *
CCliCtrTable_allocate_data(void)
{
    CCliCtrTable_data *rtn = SNMP_MALLOC_TYPEDEF(CCliCtrTable_data);

    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_allocate_data",
                "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "CCliCtrTable_data.\n");
    }

    return rtn;
}                               /* CCliCtrTable_allocate_data */

/*
 * CCliCtrTable_release_data
 *
 * Purpose: release CCliCtrTable data.
 */
void
CCliCtrTable_release_data(CCliCtrTable_data * data)
{
    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_release_data",
                "called\n"));

    free(data);
}                               /* CCliCtrTable_release_data */

/*
 *********************************************************************
 * @internal
 * allocate resources for a CCliCtrTable_rowreq_ctx
 */
CCliCtrTable_rowreq_ctx *
CCliCtrTable_allocate_rowreq_ctx(void *user_init_ctx)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        SNMP_MALLOC_TYPEDEF(CCliCtrTable_rowreq_ctx);

    DEBUGMSGTL(("internal:CCliCtrTable:CCliCtrTable_allocate_rowreq_ctx",
                "called\n"));

    if (NULL == rowreq_ctx) {
        snmp_log(LOG_ERR, "Couldn't allocate memory for a "
                 "CCliCtrTable_rowreq_ctx.\n");
    }

    rowreq_ctx->oid_idx.oids = rowreq_ctx->oid_tmp;

    rowreq_ctx->CCliCtrTable_data_list = NULL;

    /*
     * if we allocated data, call init routine
     */
    if (!(rowreq_ctx->rowreq_flags & MFD_ROW_DATA_FROM_USER)) {
        if (SNMPERR_SUCCESS !=
            CCliCtrTable_rowreq_ctx_init(rowreq_ctx, user_init_ctx)) {
            CCliCtrTable_release_rowreq_ctx(rowreq_ctx);
            rowreq_ctx = NULL;
        }
    }

    return rowreq_ctx;
}                               /* CCliCtrTable_allocate_rowreq_ctx */

/*
 * @internal
 * release resources for a CCliCtrTable_rowreq_ctx
 */
void
CCliCtrTable_release_rowreq_ctx(CCliCtrTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("internal:CCliCtrTable:CCliCtrTable_release_rowreq_ctx",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    CCliCtrTable_rowreq_ctx_cleanup(rowreq_ctx);

    if (rowreq_ctx->undo)
        CCliCtrTable_release_data(rowreq_ctx->undo);

    /*
     * free index oid pointer
     */
    if (rowreq_ctx->oid_idx.oids != rowreq_ctx->oid_tmp)
        free(rowreq_ctx->oid_idx.oids);

    SNMP_FREE(rowreq_ctx);
}                               /* CCliCtrTable_release_rowreq_ctx */

/**
 * @internal
 * wrapper
 */
static int
_mfd_CCliCtrTable_pre_request(netsnmp_mib_handler *handler,
                              netsnmp_handler_registration *reginfo,
                              netsnmp_agent_request_info *agtreq_info,
                              netsnmp_request_info *requests)
{
    int             rc;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_pre_request",
                "called\n"));

    if (1 != netsnmp_row_merge_status_first(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:CCliCtrTable",
                    "skipping additional pre_request\n"));
        return SNMP_ERR_NOERROR;
    }

    rc = CCliCtrTable_pre_request(CCliCtrTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("CCliCtrTable", "error %d from "
                    "CCliCtrTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_CCliCtrTable_post_request(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    int             rc, packet_rc;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_post_request",
                "called\n"));

    /*
     * release row context, if deleted
     */
    if (rowreq_ctx && (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED))
        CCliCtrTable_release_rowreq_ctx(rowreq_ctx);

    /*
     * wait for last call before calling user
     */
    if (1 != netsnmp_row_merge_status_last(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:CCliCtrTable",
                    "waiting for last post_request\n"));
        return SNMP_ERR_NOERROR;
    }

    packet_rc = netsnmp_check_all_requests_error(agtreq_info->asp, 0);
    if ((MFD_SUCCESS != packet_rc) && CCliCtrTable_dirty_get()) {
        /*
         * we shouldn't get here. the undo steps should also clear
         * the dirty flags.
         */
        snmp_log(LOG_WARNING,
                 "CCliCtrTable dirty flag set in post_request "
                 "but status != SUCCESS.\n");
    }

    rc = CCliCtrTable_post_request(CCliCtrTable_if_ctx.user_ctx,
                                   packet_rc);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("CCliCtrTable", "error %d from "
                    "CCliCtrTable_post_request\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_CCliCtrTable_object_lookup(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    int             rc = SNMP_ERR_NOERROR;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_object_lookup",
                "called\n"));

    /*
     * get our context from mfd
     * CCliCtrTable_interface_ctx *if_ctx =
     *             (CCliCtrTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
        rc = SNMP_ERR_NOCREATION;
    }

    if (MFD_SUCCESS != rc)
        netsnmp_request_set_error_all(requests, rc);
    else
        CCliCtrTable_row_prep(rowreq_ctx);

    return SNMP_VALIDATE_ERR(rc);
}                               /* _mfd_CCliCtrTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_CCliCtrTable_get_column(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                         netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_get_column",
                "called for %d\n", column));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * (INDEX) SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
         */
    case COLUMN_SRVIP4CLICTR:
        var->type = ASN_IPADDRESS;
        var->val_len = sizeof(u_long);
        (*var->val.integer) = rowreq_ctx->tbl_idx.SrvIp4CliCtr;
        break;

        /*
         * (INDEX) SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
         */
    case COLUMN_SRVPORT4CLICTR:
        var->type = ASN_INTEGER;
        var->val_len = sizeof(long);
        (*var->val.integer) = rowreq_ctx->tbl_idx.SrvPort4CliCtr;
        break;

        /*
         * (INDEX) GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
         */
    case COLUMN_GSIP4CLICTR:
        var->type = ASN_IPADDRESS;
        var->val_len = sizeof(u_long);
        (*var->val.integer) = rowreq_ctx->tbl_idx.GsIp4CliCtr;
        break;

        /*
         * (INDEX) GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
         */
    case COLUMN_GSPORT4CLICTR:
        var->type = ASN_INTEGER;
        var->val_len = sizeof(long);
        (*var->val.integer) = rowreq_ctx->tbl_idx.GsPort4CliCtr;
        break;

        /*
         * Stat4CliCtr(1)/CCliCtrStat/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_STAT4CLICTR:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = Stat4CliCtr_get(rowreq_ctx, (u_long *) var->val.string);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _CCliCtrTable_get_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _CCliCtrTable_get_column */

int
_mfd_CCliCtrTable_get_values(netsnmp_mib_handler *handler,
                             netsnmp_handler_registration *reginfo,
                             netsnmp_agent_request_info *agtreq_info,
                             netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_get_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _CCliCtrTable_get_column(rowreq_ctx, requests->requestvb,
                                      tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = SNMP_NOSUCHINSTANCE;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_get_values */

NETSNMP_STATIC_INLINE int
_CCliCtrTable_check_indexes(CCliCtrTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_check_indexes",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);


    /*
     * (INDEX) SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    if (MFD_SUCCESS != rc)
        return rc;
    rc = SrvIp4CliCtr_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * (INDEX) SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    if (MFD_SUCCESS != rc)
        return rc;
    rc = SrvPort4CliCtr_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * (INDEX) GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    if (MFD_SUCCESS != rc)
        return rc;
    rc = GsIp4CliCtr_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * (INDEX) GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    if (MFD_SUCCESS != rc)
        return rc;
    rc = GsPort4CliCtr_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * if individual parts look ok, check them as a whole
     */
    return CCliCtrTable_validate_index(CCliCtrTable_if_ctx.user_ctx,
                                       rowreq_ctx);
}                               /* _CCliCtrTable_check_indexes */

/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*----------------------------------------------------------------------
 *
 * SET: Syntax checks
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check the syntax for a particular column
 */
NETSNMP_STATIC_INLINE int
_CCliCtrTable_check_column(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                           netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_check_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {
        /*
         * (INDEX) SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
         */
    case COLUMN_SRVIP4CLICTR:
        rc = SNMP_ERR_NOTWRITABLE;      /* can not change index of active row */
        break;
        /*
         * (INDEX) SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
         */
    case COLUMN_SRVPORT4CLICTR:
        rc = SNMP_ERR_NOTWRITABLE;      /* can not change index of active row */
        break;
        /*
         * (INDEX) GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
         */
    case COLUMN_GSIP4CLICTR:
        rc = SNMP_ERR_NOTWRITABLE;      /* can not change index of active row */
        break;
        /*
         * (INDEX) GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
         */
    case COLUMN_GSPORT4CLICTR:
        rc = SNMP_ERR_NOTWRITABLE;      /* can not change index of active row */
        break;

        /*
         * Stat4CliCtr(1)/CCliCtrStat/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_STAT4CLICTR:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   Stat4CliCtr));
        /*
         * check that the value is one of defined enums 
         */
        if ((SNMPERR_SUCCESS == rc)
            && (*var->val.integer != CCLICTRSTAT_DESTROY)
            && (*var->val.integer != CCLICTRSTAT_CREATE)
            && (*var->val.integer != CCLICTRSTAT_ACTIVE)
            ) {
            rc = SNMP_ERR_WRONGVALUE;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("CCliCtrTable:_CCliCtrTable_check_column:Stat4CliCtr", "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = Stat4CliCtr_check_value(rowreq_ctx,
                                         *((u_long *) var->val.string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from Stat4CliCtr_check_value\n", rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

    default:    /** We shouldn't get here */
        rc = SNMP_ERR_GENERR;
        snmp_log(LOG_ERR,
                 "unknown column %d in _CCliCtrTable_check_column\n",
                 column);
    }

    return rc;
}                               /* _CCliCtrTable_check_column */

int
_mfd_CCliCtrTable_check_objects(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_check_objects",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {

        /*
         * get column number from table request info, and check that column
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _CCliCtrTable_check_column(rowreq_ctx, requests->requestvb,
                                        tri->colnum);
        if (rc) {
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));
            break;
        }

    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_check_objects */


/*----------------------------------------------------------------------
 *
 * SET: check dependencies
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check dependencies wrapper
 */
static int
_mfd_CCliCtrTable_check_dependencies(netsnmp_mib_handler *handler,
                                     netsnmp_handler_registration *reginfo,
                                     netsnmp_agent_request_info
                                     *agtreq_info,
                                     netsnmp_request_info *requests)
{
    int             rc;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_check_dependencies", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = CCliCtrTable_check_dependencies(rowreq_ctx);
    if (rc) {
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_check_dependencies\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_check_dependencies */

/*----------------------------------------------------------------------
 *
 * SET: Undo setup
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_CCliCtrTable_undo_setup_column(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                                int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_undo_setup_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * Stat4CliCtr(1)/CCliCtrStat/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_STAT4CLICTR:
        rowreq_ctx->column_set_flags |= COLUMN_STAT4CLICTR_FLAG;
        rc = Stat4CliCtr_undo_setup(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _CCliCtrTable_undo_setup_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _CCliCtrTable_undo_setup_column */


/**
 * @internal
 * undo setup
 */
int
_mfd_CCliCtrTable_undo_setup(netsnmp_mib_handler *handler,
                             netsnmp_handler_registration *reginfo,
                             netsnmp_agent_request_info *agtreq_info,
                             netsnmp_request_info *requests)
{
    int             rc;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_undo_setup",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * allocate undo context
     */
    rowreq_ctx->undo = CCliCtrTable_allocate_data();
    if (NULL == rowreq_ctx->undo) {
        /** msg already logged */
        netsnmp_request_set_error_all(requests,
                                      SNMP_ERR_RESOURCEUNAVAILABLE);
        return SNMP_ERR_NOERROR;
    }

    /*
     * row undo setup
     */
    rowreq_ctx->column_set_flags = 0;
    rc = CCliCtrTable_undo_setup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_undo_setup\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    } else {
        /*
         * column undo setup
         */
        netsnmp_table_request_info *tri;
        for (; requests; requests = requests->next) {
            /*
             * set column data
             */
            tri = netsnmp_extract_table_info(requests);
            if (NULL == tri)
                continue;

            rc = _CCliCtrTable_undo_setup_column(rowreq_ctx, tri->colnum);
            if (MFD_SUCCESS != rc) {
                DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                            "CCliCtrTable_undo_setup_column\n", rc));
                netsnmp_set_request_error(agtreq_info, requests,
                                          SNMP_VALIDATE_ERR(rc));
            }
        }                       /* for results */
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_undo_setup */

/**
 * @internal
 * undo setup
 */
int
_mfd_CCliCtrTable_undo_cleanup(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    int             rc;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_undo_cleanup",
                "called\n"));

    /*
     * failed row create in early stages has no rowreq_ctx
     */
    if (NULL == rowreq_ctx)
        return MFD_SUCCESS;

    /*
     * call user cleanup
     */
    rc = CCliCtrTable_undo_cleanup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_undo_cleanup\n", rc));
    }

    /*
     * release undo context, if needed
     */
    if (rowreq_ctx->undo) {
        CCliCtrTable_release_data(rowreq_ctx->undo);
        rowreq_ctx->undo = NULL;
    }


    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_undo_cleanup */

/*----------------------------------------------------------------------
 *
 * SET: Set values
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_CCliCtrTable_set_column(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                         netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_set_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * Stat4CliCtr(1)/CCliCtrStat/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_STAT4CLICTR:
        rowreq_ctx->column_set_flags |= COLUMN_STAT4CLICTR_FLAG;
        rc = Stat4CliCtr_set(rowreq_ctx, *((u_long *) var->val.string));
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _CCliCtrTable_set_column\n",
                 column);
        rc = SNMP_ERR_GENERR;
        break;
    }

    return rc;
}                               /* _CCliCtrTable_set_column */

int
_mfd_CCliCtrTable_set_values(netsnmp_mib_handler *handler,
                             netsnmp_handler_registration *reginfo,
                             netsnmp_agent_request_info *agtreq_info,
                             netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc = SNMP_ERR_NOERROR;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_set_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rowreq_ctx->column_set_flags = 0;
    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _CCliCtrTable_set_column(rowreq_ctx,
                                      requests->requestvb, tri->colnum);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                        "CCliCtrTable_set_column\n", rc));
            netsnmp_set_request_error(agtreq_info, requests,
                                      SNMP_VALIDATE_ERR(rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_set_values */

/*----------------------------------------------------------------------
 *
 * SET: commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit the values
 */
int
_mfd_CCliCtrTable_commit(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    int             rc;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = CCliCtrTable_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_commit\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        /*
         * if we successfully commited this row, set the dirty flag. Use the
         * current value + 1 (i.e. dirty = # rows changed).
         * this is checked in post_request...
         */
        CCliCtrTable_dirty_set(CCliCtrTable_dirty_get() + 1);   /* set table dirty flag */
    }

    return SNMP_ERR_NOERROR;
}

int
_mfd_CCliCtrTable_undo_commit(netsnmp_mib_handler *handler,
                              netsnmp_handler_registration *reginfo,
                              netsnmp_agent_request_info *agtreq_info,
                              netsnmp_request_info *requests)
{
    int             rc;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_undo_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        u_int           d = CCliCtrTable_dirty_get();

        netsnmp_assert(d != 0);
        if (d)
            CCliCtrTable_dirty_set(d - 1);
    }

    rc = CCliCtrTable_undo_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_undo_commit\n", rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        snmp_log(LOG_WARNING,
                 "CCliCtrTable row dirty flag still set after undo_commit\n");
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_commit */

/*----------------------------------------------------------------------
 *
 * SET: Undo
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * undo the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_CCliCtrTable_undo_column(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                          netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_undo_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * Stat4CliCtr(1)/CCliCtrStat/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_STAT4CLICTR:
        rc = Stat4CliCtr_undo(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _CCliCtrTable_undo_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _CCliCtrTable_undo_column */

int
_mfd_CCliCtrTable_undo_values(netsnmp_mib_handler *handler,
                              netsnmp_handler_registration *reginfo,
                              netsnmp_agent_request_info *agtreq_info,
                              netsnmp_request_info *requests)
{
    int             rc;
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_undo_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = CCliCtrTable_undo(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                    "CCliCtrTable_undo\n", rc));
    }

    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _CCliCtrTable_undo_column(rowreq_ctx, requests->requestvb,
                                       tri->colnum);
        if (MFD_SUCCESS != rc) {
            /*
             * nothing we can do about it but log it
             */
            DEBUGMSGTL(("CCliCtrTable:mfd", "error %d from "
                        "CCliCtrTable_undo_column\n", rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_undo_values */

/*----------------------------------------------------------------------
 *
 * SET: irreversible commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit irreversible actions
 */
int
_mfd_CCliCtrTable_irreversible_commit(netsnmp_mib_handler *handler,
                                      netsnmp_handler_registration
                                      *reginfo,
                                      netsnmp_agent_request_info
                                      *agtreq_info,
                                      netsnmp_request_info *requests)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:CCliCtrTable:_mfd_CCliCtrTable_irreversible:commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * check for and handle row creation/deletion
     * and update column exist flags...
     */
    if (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED) {
        CONTAINER_REMOVE(CCliCtrTable_if_ctx.container, rowreq_ctx);
    } else {
        if (rowreq_ctx->column_set_flags) {
            rowreq_ctx->column_set_flags = 0;
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_CCliCtrTable_irreversible_commit */

/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
static void     _container_free(netsnmp_container * container);

/**
 * @internal
 */
static int
_cache_load(netsnmp_cache * cache, void *vmagic)
{
    DEBUGMSGTL(("internal:CCliCtrTable:_cache_load", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache for CCliCtrTable_cache_load\n");
        return -1;
    }

    /** should only be called for an invalid or expired cache */
    netsnmp_assert((0 == cache->valid) || (1 == cache->expired));

    /*
     * call user code
     */
    return CCliCtrTable_container_load((netsnmp_container *) cache->magic);
}                               /* _cache_load */

/**
 * @internal
 */
static void
_cache_free(netsnmp_cache * cache, void *magic)
{
    netsnmp_container *container;

    DEBUGMSGTL(("internal:CCliCtrTable:_cache_free", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache in CCliCtrTable_cache_free\n");
        return;
    }

    container = (netsnmp_container *) cache->magic;

    _container_free(container);
}                               /* _cache_free */

/**
 * @internal
 */
static void
_container_item_free(CCliCtrTable_rowreq_ctx * rowreq_ctx, void *context)
{
    DEBUGMSGTL(("internal:CCliCtrTable:_container_item_free", "called\n"));

    if (NULL == rowreq_ctx)
        return;

    CCliCtrTable_release_rowreq_ctx(rowreq_ctx);
}                               /* _container_item_free */

/**
 * @internal
 */
static void
_container_free(netsnmp_container * container)
{
    DEBUGMSGTL(("internal:CCliCtrTable:_container_free", "called\n"));

    if (NULL == container) {
        snmp_log(LOG_ERR,
                 "invalid container in CCliCtrTable_container_free\n");
        return;
    }

    /*
     * call user code
     */
    CCliCtrTable_container_free(container);

    /*
     * free all items. inefficient, but easy.
     */
    CONTAINER_CLEAR(container,
                    (netsnmp_container_obj_func *) _container_item_free,
                    NULL);
}                               /* _container_free */

/**
 * @internal
 * initialize the container with functions or wrappers
 */
void
_CCliCtrTable_container_init(CCliCtrTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_init",
                "called\n"));

    /*
     * cache init
     */
    if_ctx->cache = netsnmp_cache_create(30,    /* timeout in seconds */
                                         _cache_load, _cache_free,
                                         CCliCtrTable_oid,
                                         CCliCtrTable_oid_size);

    if (NULL == if_ctx->cache) {
        snmp_log(LOG_ERR, "error creating cache for CCliCtrTable\n");
        return;
    }

    if_ctx->cache->flags = NETSNMP_CACHE_DONT_INVALIDATE_ON_SET;

    CCliCtrTable_container_init(&if_ctx->container, if_ctx->cache);
    if (NULL == if_ctx->container)
        if_ctx->container =
            netsnmp_container_find("CCliCtrTable:table_container");
    if (NULL == if_ctx->container) {
        snmp_log(LOG_ERR, "error creating container in "
                 "CCliCtrTable_container_init\n");
        return;
    }

    if (NULL != if_ctx->cache)
        if_ctx->cache->magic = (void *) if_ctx->container;
}                               /* _CCliCtrTable_container_init */

/**
 * @internal
 * shutdown the container with functions or wrappers
 */
void
_CCliCtrTable_container_shutdown(CCliCtrTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_shutdown",
                "called\n"));

    CCliCtrTable_container_shutdown(if_ctx->container);

    _container_free(if_ctx->container);

}                               /* _CCliCtrTable_container_shutdown */

/***********************************************************************
 *
 * PERSISTENCE
 *
 ***********************************************************************/

static int      _CCliCtrTable_container_save_rows(int majorID, int minorID,
                                                  void *serverarg,
                                                  void *clientarg);
static void     _CCliCtrTable_container_row_restore(const char *token,
                                                    char *buf);
static int      _CCliCtrTable_container_row_save(CCliCtrTable_rowreq_ctx *
                                                 rowreq_ctx, void *type);
static char    *_CCliCtrTable_container_col_restore(CCliCtrTable_rowreq_ctx
                                                    * rowreq_ctx,
                                                    u_int col, char *buf);
static char    *_CCliCtrTable_container_col_save(CCliCtrTable_rowreq_ctx *
                                                 rowreq_ctx, u_int col,
                                                 char *buf);

static char     row_token[] = "CCliCtrTable";

/************************************************************
 * *_init_persistence should be called from the main table
 * init routine.
 *
 * If your table depends on rows in another table,
 * you should register your callback after the other table,
 * which should ensure the rows on which you depend are saved
 * (and re-created) before the dependent rows.
 */
void
CCliCtrTable_container_init_persistence(netsnmp_container * container)
{
    int             rc;

    register_config_handler(NULL, row_token,
                            _CCliCtrTable_container_row_restore, NULL,
                            NULL);
    rc = snmp_register_callback(SNMP_CALLBACK_LIBRARY,
                                SNMP_CALLBACK_STORE_DATA,
                                _CCliCtrTable_container_save_rows,
                                container);

    if (rc != SNMP_ERR_NOERROR)
        snmp_log(LOG_ERR, "error registering for STORE_DATA callback "
                 "in _CCliCtrTable_container_init_persistence\n");
}

static int
_CCliCtrTable_container_save_rows(int majorID, int minorID,
                                  void *serverarg, void *clientarg)
{
    char            sep[] =
        "##############################################################";
    char            buf[] = "#\n" "# CCliCtrTable persistent data\n" "#";
    char           *type = netsnmp_ds_get_string(NETSNMP_DS_LIBRARY_ID,
                                                 NETSNMP_DS_LIB_APPTYPE);

    read_config_store((char *) type, sep);
    read_config_store((char *) type, buf);

    /*
     * save all rows
     */
    CONTAINER_FOR_EACH((netsnmp_container *) clientarg,
                       (netsnmp_container_obj_func *)
                       _CCliCtrTable_container_row_save, type);

    read_config_store((char *) type, sep);
    read_config_store((char *) type, "\n");

    /*
     * never fails 
     */
    return SNMPERR_SUCCESS;
}



/************************************************************
 * _CCliCtrTable_container_row_save
 */
static int
_CCliCtrTable_container_row_save(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                                 void *type)
{
    /*
     * Allocate space for a line with all data for a row. An
     * attempt is made to come up with a default maximum size, but
     * there is no guarantee it will be enough. It probably will be,
     * unless you are dealing with large values or you have external
     * indexes.
     *
     * 1) allocate space for each column. Comment out columns you don't
     * intend to save. You may also need to add room for any non-
     * column data you want to store. Remeber, data will be stored in
     * ASCII form, so you need to allow for that. Here are some
     * general guidelines:
     *
     *   Object ID   :  12 * len [ASCII len of max int + 1 for .]
     *   Octet String: (2 * len) + 2 [2 ASCII chars per byte + "0x"]
     *   Integers    :  12 [ASCII len for smallest negative number]
     *
     * 2) You also need to allocate space for the row index. This will
     * be stored as an OID, which means that Octet Strings need to
     * be treated a little differently. Specifically, you will need
     * (4 * len) + 4 [3 ASCII chars per byte + 1 for ., + 4 for len].
     *
     * 3) Also, remeber to add space for the identifier and seperator
     * characters (for example, each column is prefixed by the
     * column number and a semicolon. To allow for the maximum
     * column values, 12 bytes [11 for oid + 1 for ':'] per
     * column are added).
     */
        /** xxx: add storage for external index(s)! */
#define MAX_ROW_SIZE (sizeof(row_token) + 1 +  \
        ( 12 ) + /* ASN_INTEGER Stat4CliCtr */ \
        ( CCLICTRTABLE_MAX_COL * 12 ) + /* column num prefix + : */ \
    2 /* LINE_TERM_CHAR + \n */ )

    char            buf[MAX_ROW_SIZE], *pos = buf, *max =
        &buf[MAX_ROW_SIZE - 1];
    char           *tmp;
    int             i;

    if (CCliCtrTable_container_should_save(rowreq_ctx) == 0) {
        return SNMP_ERR_NOERROR;
    }

    /*
     * build the line
     */
    pos += sprintf(pos, "%s ", row_token);
    pos = read_config_save_objid(pos, rowreq_ctx->oid_idx.oids,
                                 rowreq_ctx->oid_idx.len);
    if (NULL == pos) {
        snmp_log(LOG_ERR, "error saving CCliCtrTable row "
                 "to persistent file\n");
        return SNMP_ERR_GENERR;
    }
    *pos++ = ' ';
    if (pos > max) {
        snmp_log(LOG_ERR, "error saving CCliCtrTable row "
                 "to persistent file (too long)\n");
        return SNMP_ERR_GENERR;
    }

    /*
     * add each column
     */
    for (i = CCLICTRTABLE_MIN_COL; i <= CCLICTRTABLE_MAX_COL; ++i) {

        if ((0x1 << (i - 1)) & ~CCLICTRTABLE_SETTABLE_COLS)
            continue;

        tmp = pos;
        pos = _CCliCtrTable_container_col_save(rowreq_ctx, i, pos);
        if (NULL == pos)
            pos = tmp;
        else
            *pos++ = ' ';
        if (pos > max) {
            snmp_log(LOG_ERR, "error saving CCliCtrTable row "
                     "to persistent file (too long)\n");
            return SNMP_ERR_GENERR;
        }
    }

    /*
     * if you have non-column data, add it here
     */


    /*
     * store the line
     */
    pos += sprintf(pos, "%c", LINE_TERM_CHAR);
    if (pos > max) {
        snmp_log(LOG_ERR, "error saving CCliCtrTable row "
                 "to persistent file (too long)\n");
        return SNMP_ERR_GENERR;
    }
    read_config_store((char *) type, buf);

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_row_save",
                "saving line '%s'\n", buf));

    return SNMP_ERR_NOERROR;
}

static void
_CCliCtrTable_container_row_restore(const char *token, char *buf)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx;
    netsnmp_index   index;
    oid             tmp_oid[MAX_CCliCtrTable_IDX_LEN];
    u_int           col = 0, found = 0;


    if (strncmp(token, row_token, sizeof(row_token)) != 0) {
        snmp_log(LOG_ERR,
                 "unknown token in _CCliCtrTable_container_row_restore\n");
        return;
    }

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_row_restore", "parsing line '%s'\n", buf));

    /*
     * pull out index and create default row
     */
    index.oids = tmp_oid;
    index.len = OID_LENGTH(tmp_oid);
    buf = read_config_read_objid(buf, &index.oids, &index.len);
    if (NULL == buf) {
        snmp_log(LOG_ERR, "error reading row index in "
                 "_CCliCtrTable_container_row_restore\n");
        return;
    }
    rowreq_ctx = _mfd_CCliCtrTable_rowreq_from_index(&index, NULL);
    if (NULL == rowreq_ctx) {
        snmp_log(LOG_ERR, "error creating row index in "
                 "_CCliCtrTable_container_row_restore\n");
        return;
    }

    /*
     * loop through and get each column
     */
    buf = skip_white(buf);
    while ((NULL != buf) && isdigit(*buf)) {
        /*
         * extract column, skip ':'
         */
        col = (u_int) strtol(buf, &buf, 10);
        if (NULL == buf)
            break;
        if (*buf != ':') {
            buf = NULL;
            break;
        }
        ++buf;                  /* skip : */

        /*
         * parse value
         */
        DEBUGMSGTL(("_CCliCtrTable_container_row_restore",
                    "parsing column %d\n", col));
        buf = _CCliCtrTable_container_col_restore(rowreq_ctx, col, buf);
        ++found;
    }
    if (0 == found) {
        snmp_log(LOG_ERR,
                 "error parsing CCliCtrTable row; no columns found\n");
        CCliCtrTable_release_rowreq_ctx(rowreq_ctx);
        return;
    }

    /*
     * if you added any non-column data, this is where
     * you should handle it.
     */

    /*
     * if the pointer is NULL and we didn't reach the
     * end of the line, something went wrong. Log message,
     * delete the row and bail.
     */
    if ((buf == NULL) || (*buf != LINE_TERM_CHAR)) {
        snmp_log(LOG_ERR,
                 "error parsing CCliCtrTable row around column %d\n", col);
        CCliCtrTable_release_rowreq_ctx(rowreq_ctx);
        return;
    }

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_row_restore", "inserting row\n"));

    /*
     * copy oid index and insert row
     */
    rowreq_ctx->oid_idx.len = index.len;
    memcpy(rowreq_ctx->oid_idx.oids, index.oids, index.len * sizeof(oid));

    CONTAINER_INSERT(CCliCtrTable_if_ctx.container, rowreq_ctx);
}

/************************************************************
 * _CCliCtrTable_container_col_save
 */
static char    *
_CCliCtrTable_container_col_save(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                                 u_int col, char *buf)
{
    if ((NULL == rowreq_ctx) || (NULL == buf)) {
        snmp_log(LOG_ERR, "bad parameter in "
                 "_CCliCtrTable_container_col_save\n");
        return NULL;
    }

    DEBUGMSGTL(("internal:CCliCtrTable:_CCliCtrTable_container_col_save",
                "processing column %d\n", col));

    /*
     * prefix with column number, so we don't ever depend on
     * order saved.
     */
    buf += sprintf(buf, "%u:", col);

    /*
     * save data for the column
     */
    switch (col) {

    case COLUMN_STAT4CLICTR:    /** CCliCtrStat = ASN_INTEGER */
        buf += sprintf(buf, "%ld", rowreq_ctx->data.Stat4CliCtr);
        break;

    default:/** We shouldn't get here */
        snmp_log(LOG_ERR, "unknown column %d in "
                 "_CCliCtrTable_container_col_save\n", col);
        return NULL;
    }

    return buf;
}

/************************************************************
 * _CCliCtrTable_container_col_restore
 */
static char    *
_CCliCtrTable_container_col_restore(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                                    u_int col, char *buf)
{
    size_t          len;
    if ((NULL == rowreq_ctx) || (NULL == buf)) {
        snmp_log(LOG_ERR, "bad parameter in "
                 "_CCliCtrTable_container_col_restore\n");
        return NULL;
    }

    DEBUGMSGTL(("verbose:CCliCtrTable:_CCliCtrTable_container_col_restore",
                "processing column %d\n", col));

    /*
     * restore data for the column
     */
    switch (col) {

    case COLUMN_STAT4CLICTR:    /** CCliCtrStat = ASN_INTEGER */
        len = sizeof(rowreq_ctx->data.Stat4CliCtr);
        buf = read_config_read_memory(ASN_INTEGER, buf,
                                      (char *) &rowreq_ctx->data.
                                      Stat4CliCtr, &len);
        break;

    default:/** We shouldn't get here */
        snmp_log(LOG_ERR, "unknown column %d in "
                 "_CCliCtrTable_container_col_restore\n", col);
        return NULL;
    }

    return buf;
}


CCliCtrTable_rowreq_ctx *
CCliCtrTable_row_find_by_mib_index(CCliCtrTable_mib_index * mib_idx)
{
    CCliCtrTable_rowreq_ctx *rowreq_ctx;
    oid             oid_tmp[MAX_OID_LEN];
    netsnmp_index   oid_idx;
    int             rc;

    /*
     * set up storage for OID
     */
    oid_idx.oids = oid_tmp;
    oid_idx.len = sizeof(oid_tmp) / sizeof(oid);

    /*
     * convert
     */
    rc = CCliCtrTable_index_to_oid(&oid_idx, mib_idx);
    if (MFD_SUCCESS != rc)
        return NULL;

    rowreq_ctx = CONTAINER_FIND(CCliCtrTable_if_ctx.container, &oid_idx);

    return rowreq_ctx;
}
