/*
 * Note: this file originally auto-generated by mib2c using
 *  : mib2c.iterate.conf 15999 2007-03-25 22:32:02Z dts12 $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "myifTable.h"

struct myifTable_entry  if_table[MAX_NUM_IF];

/* Typical data structure for a row entry */
struct myifTable_entry {
    /* Index values */
    u_long myifTableIndex;

    /* Column values */
    long myifSpeedSettings;
    long old_myifSpeedSettings;
    long myifSpeedActual;
    long myifMode;
    long old_myifMode;
    long myifOperStatus;
    char myifPhysAddress[NNN];
    size_t myifPhysAddress_len;
    u_long myipAdEntAddr;
    u_long myipAdEntNetMask;
    u_long myipGatewayAddr;
    u_long old_myipGatewayAddr;

    /* Illustrate using a simple linked list */
    int   valid;
    struct myifTable_entry *next;
};

/** Initializes the myifTable module */
void
init_myifTable(void)
{
  /* here we initialize all the tables we're planning on supporting */
    initialize_table_myifTable();
}

/** Initialize the myifTable table by defining its contents and how it's structured */
void
initialize_table_myifTable(void)
{
    static oid myifTable_oid[] = {1,3,6,1,4,1,1166,1,14,1,2,6,1};
    size_t myifTable_oid_len   = OID_LENGTH(myifTable_oid);
    netsnmp_handler_registration    *reg;
    netsnmp_iterator_info           *iinfo;
    netsnmp_table_registration_info *table_info;
    int x;

    reg = netsnmp_create_handler_registration(
              "myifTable",     myifTable_handler,
              myifTable_oid, myifTable_oid_len,
              HANDLER_CAN_RWRITE
              );

    table_info = SNMP_MALLOC_TYPEDEF( netsnmp_table_registration_info );
    netsnmp_table_helper_add_indexes(table_info,
                           ASN_UNSIGNED,  /* index: myifTableIndex */
                           0);
    table_info->min_column = 1;
    table_info->max_column = 9;
    
    iinfo = SNMP_MALLOC_TYPEDEF( netsnmp_iterator_info );
    iinfo->get_first_data_point = myifTable_get_first_data_point;
    iinfo->get_next_data_point  = myifTable_get_next_data_point;
    iinfo->table_reginfo        = table_info;
    
    netsnmp_register_table_iterator( reg, iinfo );

    /* Initialise the contents of the table here */
    for (x = 0; x < MAX_NUM_IF; x++)
    {
        if_table[x].myifTableIndex = x+1;
    }
}

struct myifTable_entry  *myifTable_head;

/* create a new row in the (unsorted) table */
struct myifTable_entry *
myifTable_createEntry(
                 u_long  myifTableIndex
                ) {
    struct myifTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct myifTable_entry);
    if (!entry)
        return NULL;

    entry->myifTableIndex = myifTableIndex;
    entry->next = myifTable_head;
    myifTable_head = entry;
    return entry;
}

/* remove a row from the table */
void
myifTable_removeEntry( struct myifTable_entry *entry ) {
    struct myifTable_entry *ptr, *prev;

    if (!entry)
        return;    /* Nothing to remove */

    for ( ptr  = myifTable_head, prev = NULL;
          ptr != NULL;
          prev = ptr, ptr = ptr->next ) {
        if ( ptr == entry )
            break;
    }
    if ( !ptr )
        return;    /* Can't find it */

    if ( prev == NULL )
        myifTable_head = ptr->next;
    else
        prev->next = ptr->next;

    SNMP_FREE( entry );   /* XXX - release any other internal resources */
}


/* Example iterator hook routines - using 'get_next' to do most of the work */
netsnmp_variable_list *
myifTable_get_first_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct myifTable_entry *entry;
    netsnmp_variable_list *idx = put_index_data;
    DEBUGMSGTL(("temp", "if table get first\n"));

    *my_loop_context = myifTable_head;
    *my_loop_context = &if_table[0];
    *my_data_context = &if_table[0];
    
    entry = *my_loop_context;
    
    snmp_set_var_value(vptr, (u_char *)&entry->myifTableIndex,
    sizeof(entry->myifTableIndex) );
    idx = idx->next_variable;

    return put_index_data;
}

netsnmp_variable_list *
myifTable_get_next_data_point(void **my_loop_context,
                          void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    struct myifTable_entry *entry = (struct myifTable_entry *)*my_loop_context;
    netsnmp_variable_list *idx = put_index_data;
    DEBUGMSGTL(("temp", "if table get next\n"));

    if (entry == &if_table[MAX_NUM_IF-1])
    {
        return NULL;
    }
    entry++;
    *my_data_context = (void *)entry;
    *my_loop_context = (void *)entry;
    snmp_set_var_value(idx, (u_char *)&entry->myifTableIndex,
        sizeof(entry->myifTableIndex) );
    idx = idx->next_variable;
    
    return put_index_data;
}


/** handles requests for the myifTable table */
int
myifTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info       *request;
    netsnmp_table_request_info *table_info;
    struct myifTable_entry          *table_entry;
    int val, if_mode;
    int speed = 0;
    int duplex = 0;
    struct fe_stats_s           fe_stats;
    struct  in_addr fe_ip_addr;
    char PhysAddress[50];

    snmp_log(LOG_ERR, "in myiftable_handler: %d\n", reqinfo->mode );

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request=requests; request; request=request->next) {
            table_entry = (struct myifTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);
            
            if (table_entry == NULL)
            {
                snmp_log(LOG_ERR, "in mode-get: table_entry is null\n", reqinfo->mode ); //debugging
                netsnmp_request_set_error(request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            if (table_info == NULL)
            {
                continue;
            }
            val = *table_info->indexes->val.integer;

            snmp_log(LOG_ERR, "in mode-get: table_entry is NOT null\n", reqinfo->mode );  //debugging
            snmp_log(LOG_ERR, "in mode-get: table_info->colnum %d\n", table_info->colnum ); //debugging
            
            switch (table_info->colnum) {
            case COLUMN_MYIFSPEEDSETTINGS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                getspeed(val, &table_entry->myifSpeedSettings);
                snmp_set_var_typed_value( request->requestvb, ASN_INTEGER,
                               (char *)&table_entry->myifSpeedSettings,
                               sizeof(table_entry->myifSpeedSettings));
                break;
            case COLUMN_MYIFSPEEDACTUAL:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
               table_entry->myifSpeedActual = 100;

                snmp_set_var_typed_value( request->requestvb, ASN_INTEGER,
                               (char *)&table_entry->myifSpeedActual,
                               sizeof(table_entry->myifSpeedActual));
                break;
            case COLUMN_MYIFMODE:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                getmode(val, &table_entry->myifMode);
                snmp_set_var_typed_value( request->requestvb, ASN_INTEGER,
                               (char *)&table_entry->myifMode,
                               sizeof(table_entry->myifMode));
                break;
            case COLUMN_MYIFOPERSTATUS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
               
                table_entry->myifOperStatus = UP;
                snmp_set_var_typed_value( request->requestvb, ASN_INTEGER,
                               (char *)&table_entry->myifOperStatus,
                               sizeof(table_entry->myifOperStatus));
                break;
            case COLUMN_MYIFPHYSADDRESS:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value( request->requestvb, ASN_OCTET_STR,
                               (u_char *)fe_stats.hwaddr.sa_data,
                               MAX_MAC_LEN);
                break;
            case COLUMN_MYIPADENTADDR:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                fe_ip_addr.s_addr = (((struct sockaddr_in*)&(fe_stats.addr))->sin_addr).s_addr;
                    table_entry->myipAdEntAddr = fe_ip_addr.s_addr;
               
                snmp_set_var_typed_value( request->requestvb, ASN_IPADDRESS,
                               (char *)&table_entry->myipAdEntAddr,
                               sizeof(table_entry->myipAdEntAddr));
                break;
            case COLUMN_MYIPADENTNETMASK:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                    fe_ip_addr.s_addr = (((struct sockaddr_in*)&(fe_stats.netmask))->sin_addr).s_addr;
                    table_entry->myipAdEntNetMask = fe_ip_addr.s_addr;
               
                snmp_set_var_typed_value( request->requestvb, ASN_IPADDRESS,
                               (char *)&table_entry->myipAdEntNetMask,
                               sizeof(table_entry->myipAdEntNetMask));
                break;
            case COLUMN_MYIPGATEWAYADDR:
                if ( !table_entry ) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                getipgatewayaddr(val, &table_entry->myipGatewayAddr);
                snmp_set_var_typed_value( request->requestvb, ASN_IPADDRESS,
                               (char *)&table_entry->myipGatewayAddr,
                               sizeof(table_entry->myipGatewayAddr));
                break;
            }
        }
        break;

        /*
         * Write-support
         */
    case MODE_SET_RESERVE1:
        for (request=requests; request; request=request->next) {
            table_entry = (struct myifTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);
   
            switch (table_info->colnum) {
            case COLUMN_MYIFSPEEDSETTINGS:
                if ( request->requestvb->type != ASN_INTEGER ) {
                    netsnmp_set_request_error( reqinfo, request,
                                               SNMP_ERR_WRONGTYPE );
                    return SNMP_ERR_NOERROR;
                }
                /* Also may need to check size/value */
                break;
            case COLUMN_MYIFMODE:
                if ( request->requestvb->type != ASN_INTEGER ) {
                    netsnmp_set_request_error( reqinfo, request,
                                               SNMP_ERR_WRONGTYPE );
                    return SNMP_ERR_NOERROR;
                }
                break;
            case COLUMN_MYIPGATEWAYADDR:
                if ( request->requestvb->type != ASN_IPADDRESS ) {
                    netsnmp_set_request_error( reqinfo, request,
                                              SNMP_ERR_WRONGTYPE );
                    return SNMP_ERR_NOERROR;
                }
                break;
            default:
                netsnmp_set_request_error( reqinfo, request,
                                           SNMP_ERR_NOTWRITABLE );
                return SNMP_ERR_NOERROR;
            }
        }
        break;

    case MODE_SET_RESERVE2:
        break;

    case MODE_SET_FREE:
        break;

    case MODE_SET_ACTION:
        for (request=requests; request; request=request->next) {
            table_entry = (struct myifTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);
    
            val = *table_info->indexes->val.integer;
            switch (table_info->colnum) {
            case COLUMN_MYIFSPEEDSETTINGS:
                getifspeedmode(val, &if_mode);
                if (if_mode != *request->requestvb->val.integer)
                {
                    if (!setifspeedmode(val,*request->requestvb->val.integer))
                    {
                        netsnmp_set_request_error( reqinfo, request,
                            SNMP_ERR_COMMITFAILED);
                        return SNMP_ERR_NOERROR;
                    }
                }
                table_entry->myifSpeedSettings = *request->requestvb->val.integer;
                break;
            case COLUMN_MYIFMODE:
                getifmode(val, &if_mode);
                if (if_mode != *request->requestvb->val.integer)
                {
                    if (!setifmode(val,*request->requestvb->val.integer))
                    {
                        netsnmp_set_request_error( reqinfo, request,
                            SNMP_ERR_COMMITFAILED);
                        return SNMP_ERR_NOERROR;
                    }
                }
                table_entry->myifMode = *request->requestvb->val.integer;
                break;
            case COLUMN_MYIPGATEWAYADDR:
                if(!setipgatewayaddr(val, *request->requestvb->val.integer))
                {
                    netsnmp_set_request_error( reqinfo, request,
                        SNMP_ERR_COMMITFAILED);
                    return SNMP_ERR_NOERROR;
                }
                break;
            }
        }
        break;

    case MODE_SET_UNDO:
        for (request=requests; request; request=request->next) {
            table_entry = (struct myifTable_entry *)
                              netsnmp_extract_iterator_context(request);
            table_info  =     netsnmp_extract_table_info(      request);

            switch (table_info->colnum) {
            case COLUMN_MYIFSPEEDSETTINGS:
                break;
            case COLUMN_MYIFMODE:
                break;
            }
        }
        break;
    
    case MODE_SET_COMMIT:
        break;
    }
    return SNMP_ERR_NOERROR;
}
