/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.iterate_access.conf 17695 2009-07-21 12:22:18Z dts12 $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "ttfCfgTable.h"
#include "ttfCfgTable_checkfns.h"
#include "ttfCfgTable_access.h"

static netsnmp_oid_stash_node *undoStorage = NULL;
static netsnmp_oid_stash_node *commitStorage = NULL;

struct undoInfo {
   void *ptr;
   size_t len;
};

struct commitInfo {
   void *data_context;
   int have_committed;
   int new_row;
};

void
ttfCfgTable_free_undoInfo(void *vptr) {
    struct undoInfo *ui = vptr;
    if (!ui)
        return;
    SNMP_FREE(ui->ptr);
    SNMP_FREE(ui);
}

/** Initialize the ttfCfgTable table by defining its contents and how it's structured */
void
initialize_table_ttfCfgTable(void)
{
    const oid ttfCfgTable_oid[] = {1,3,6,1,4,1,22638,3,4,3,1,1};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    DEBUGMSGTL(("ttfCfgTable:init", "initializing table ttfCfgTable\n"));

    /** create the table registration information structures */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    my_handler = netsnmp_create_handler_registration("ttfCfgTable",
                                             ttfCfgTable_handler,
                                             ttfCfgTable_oid,
                                             OID_LENGTH(ttfCfgTable_oid),
                                             HANDLER_CAN_RWRITE
                                             );
            
    if (!my_handler || !table_info || !iinfo) {
        snmp_log(LOG_ERR, "malloc failed in initialize_table_ttfCfgTable");
        return; /** Serious error. */
    }

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /** index: ttfCfgSlot */
                                  ASN_INTEGER, /** index: ttfCfgFunctionGroup */
                                  ASN_INTEGER, /** index: ttfCfgFunctionUnit */
                             0);

    /** Define the minimum and maximum accessible columns.  This
        optimizes retrival. */
    table_info->min_column = 4;
    table_info->max_column = 16;

    /** iterator access routines */
    iinfo->get_first_data_point = ttfCfgTable_get_first_data_point;
    iinfo->get_next_data_point = ttfCfgTable_get_next_data_point;

    /** you may wish to set these as well */
#ifdef MAYBE_USE_THESE
    iinfo->make_data_context = ttfCfgTable_context_convert_function;
    iinfo->free_data_context = ttfCfgTable_data_free;

    /** pick *only* one of these if you use them */
    iinfo->free_loop_context = ttfCfgTable_loop_free;
    iinfo->free_loop_context_at_end = ttfCfgTable_loop_free;
#endif

    /** tie the two structures together */
    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_ttfCfgTable",
                "Registering table ttfCfgTable as a table iterator\n"));		 
    netsnmp_register_table_iterator(my_handler, iinfo);
}

/** Initializes the ttfCfgTable module */
void
init_ttfCfgTable(void)
{

  /** here we initialize all the tables we're planning on supporting */
    initialize_table_ttfCfgTable();
}

/** handles requests for the ttfCfgTable table, if anything else needs to be done */
int
ttfCfgTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    struct commitInfo *ci = NULL;

    void *data_context = NULL;

    /** column and row index encoded portion */
    const oid * const suffix =
        requests->requestvb->name + reginfo->rootoid_len + 1;
    const size_t suffix_len = requests->requestvb->name_length -
        (reginfo->rootoid_len + 1);
    
    DEBUGMSGTL(("ttfCfgTable:handler", "Processing request (%d)\n", reqinfo->mode));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        switch (reqinfo->mode) {
        case MODE_GET:
            data_context =  netsnmp_extract_iterator_context(request);
            if (data_context == NULL) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHINSTANCE);
                continue;
            }
            break;

        case MODE_SET_RESERVE1:
            data_context =  netsnmp_extract_iterator_context(request);
            if (data_context == NULL) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_ERR_NOCREATION);
                continue;
            }
            break;

        default: /* == the other SET modes */
            ci = netsnmp_oid_stash_get_data(commitStorage,
                                            suffix+1, suffix_len-1);
            break;
        }

        /** extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /** table_info->colnum contains the column number requested */
        /** table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info == NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_TTFCFGSPIFORCEDSHUTDOWN:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgSpiForcedShutdown(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGSPIALS:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgSpiAls(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGSPILASERONMANUAL:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgSpiLaserOnManual(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGSPIPORTMODE:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgSpiPortMode(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGLOOPINT:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgLoopInt(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGLOOPEXT:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgLoopExt(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGLOOPINTLASERON:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgLoopIntLaserOn(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGLOOPREMOVETIME:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgLoopRemoveTime(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGREGJ0ENABLE:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgRegJ0Enable(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGMULTIBADSECEBCTHRESHOLD:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgMultiBadSecEbcThreshold(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    case COLUMN_TTFCFGMULTIBADSECTHRESHOLD:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                retval = get_ttfCfgMultiBadSecThreshold(data_context, &retval_len);
                                if (retval)
                                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                                         (const u_char *) retval,
                                                         retval_len);
                            }
                        break;

                    default:
                /** We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in ttfCfgTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                ci = netsnmp_oid_stash_get_data(commitStorage,
                                                suffix+1, suffix_len-1);
                
                if (!ci) {
                    /** create the commit storage info */
                    ci = SNMP_MALLOC_STRUCT(commitInfo);
                    if (!data_context) {
                        ci->data_context = ttfCfgTable_create_data_context(table_info->indexes, table_info->colnum);
                        ci->new_row = 1;
                    } else {
                        ci->data_context = data_context;
                    }
                    netsnmp_oid_stash_add_data(&commitStorage,
                                               suffix+1, suffix_len-1, ci);
                }
            break;
                
            case MODE_SET_RESERVE2:
                switch(table_info->colnum) {
                          case COLUMN_TTFCFGSPIFORCEDSHUTDOWN:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgSpiForcedShutdown(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgSpiForcedShutdown(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGSPIALS:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgSpiAls(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgSpiAls(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGSPILASERONMANUAL:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgSpiLaserOnManual(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgSpiLaserOnManual(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGSPIPORTMODE:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgSpiPortMode(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgSpiPortMode(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINT:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgLoopInt(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgLoopInt(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGLOOPEXT:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgLoopExt(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgLoopExt(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINTLASERON:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgLoopIntLaserOn(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgLoopIntLaserOn(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGLOOPREMOVETIME:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgLoopRemoveTime(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgLoopRemoveTime(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGREGJ0ENABLE:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgRegJ0Enable(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgRegJ0Enable(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECEBCTHRESHOLD:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgMultiBadSecEbcThreshold(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgMultiBadSecEbcThreshold(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECTHRESHOLD:
                            {
                                long *retval;
                                size_t retval_len = 0;
                                struct undoInfo *ui = NULL;
                                int ret;
                                
                    /** first, get the old value */
                                retval = get_ttfCfgMultiBadSecThreshold(ci->data_context, &retval_len);
                                if (retval) {
                                    ui = SNMP_MALLOC_STRUCT(undoInfo);
                                    ui->len = retval_len;
                                    memdup((u_char **) &ui->ptr,
                                           (u_char *) retval,
                                           ui->len);
                                }

                    /** check the new value, possibly against the
                        older value for a valid state transition */
                                ret = check_ttfCfgMultiBadSecThreshold(request->requestvb->type,
                                                   (long *) request->requestvb->val.string,
                                                   request->requestvb->val_len,
                                                   retval, retval_len);
                                if (ret != 0) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                    ttfCfgTable_free_undoInfo(ui);
                                } else if (ui) {
                        /** remember information for undo purposes later */
                                    netsnmp_oid_stash_add_data(&undoStorage,
                                                               suffix,
                                                               suffix_len,
                                                               ui);
                                }
                                
                            }
                            break;
                    default:
                       netsnmp_set_request_error(reqinfo, request,
                                                 SNMP_ERR_NOTWRITABLE);
                       break;
                 }
                break;

            case MODE_SET_ACTION:
            /** save a variable copy */
                switch(table_info->colnum) {
                          case COLUMN_TTFCFGSPIFORCEDSHUTDOWN:
                            {
                                int ret;
                                ret = set_ttfCfgSpiForcedShutdown(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPIALS:
                            {
                                int ret;
                                ret = set_ttfCfgSpiAls(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPILASERONMANUAL:
                            {
                                int ret;
                                ret = set_ttfCfgSpiLaserOnManual(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPIPORTMODE:
                            {
                                int ret;
                                ret = set_ttfCfgSpiPortMode(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINT:
                            {
                                int ret;
                                ret = set_ttfCfgLoopInt(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPEXT:
                            {
                                int ret;
                                ret = set_ttfCfgLoopExt(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINTLASERON:
                            {
                                int ret;
                                ret = set_ttfCfgLoopIntLaserOn(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPREMOVETIME:
                            {
                                int ret;
                                ret = set_ttfCfgLoopRemoveTime(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGREGJ0ENABLE:
                            {
                                int ret;
                                ret = set_ttfCfgRegJ0Enable(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECEBCTHRESHOLD:
                            {
                                int ret;
                                ret = set_ttfCfgMultiBadSecEbcThreshold(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECTHRESHOLD:
                            {
                                int ret;
                                ret = set_ttfCfgMultiBadSecThreshold(ci->data_context,
                                             (long *) request->requestvb->val.string,
                                             request->requestvb->val_len);
                                if (ret) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              ret);
                                }
                            }
                            break;
                 }
                break;

            case MODE_SET_COMMIT:
                if (!ci->have_committed) {
                    /** do this once per row only */
                    ttfCfgTable_commit_row(&ci->data_context, ci->new_row);
                    ci->have_committed = 1;
                }
                break;

            case MODE_SET_UNDO:
             /** save a variable copy */
                switch(table_info->colnum) {
                          case COLUMN_TTFCFGSPIFORCEDSHUTDOWN:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgSpiForcedShutdown(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPIALS:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgSpiAls(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPILASERONMANUAL:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgSpiLaserOnManual(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGSPIPORTMODE:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgSpiPortMode(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINT:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgLoopInt(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPEXT:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgLoopExt(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPINTLASERON:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgLoopIntLaserOn(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGLOOPREMOVETIME:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgLoopRemoveTime(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGREGJ0ENABLE:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgRegJ0Enable(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECEBCTHRESHOLD:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgMultiBadSecEbcThreshold(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                          case COLUMN_TTFCFGMULTIBADSECTHRESHOLD:
                            {
                                int retval;
                                struct undoInfo *ui;
                                ui = netsnmp_oid_stash_get_data(undoStorage,
                                                                suffix,
                                                                suffix_len);
                                retval = set_ttfCfgMultiBadSecThreshold(ci->data_context, ui->ptr,
                                                ui->len);
                                if (retval) {
                                    netsnmp_set_request_error(reqinfo, request,
                                                              SNMP_ERR_UNDOFAILED);
                                }
                            }
                            break;
                }
                break;
                
            case MODE_SET_FREE:
                break;

            default:
                snmp_log(LOG_ERR, "problem encountered in ttfCfgTable_handler: unsupported mode\n");
        }
    }

    /** clean up after all requset processing has ended */
    switch(reqinfo->mode) {
    case MODE_SET_UNDO:
    case MODE_SET_FREE:
    case MODE_SET_COMMIT:
        /** clear out the undo cache */
        netsnmp_oid_stash_free(&undoStorage, ttfCfgTable_free_undoInfo);
        netsnmp_oid_stash_free(&commitStorage, netsnmp_oid_stash_no_free);
    }

    return SNMP_ERR_NOERROR;
}
