var canvas;
var ctx;
$(document).ready(function(){
	canvas = document.getElementById("me");
	ctx = canvas.getContext("2d");
	doStuff();
	setInterval('doStuff()', 150000);
});
function doStuff(){
	$.getJSON('getsvg.php', function(data) {
		$.eachDelay(data, function(key, val) {
			var coords = data[key].path;
			ctx.fillStyle = data[key].color;
			makeShape(coords);

		}, 250);
	});
	$.getJSON('gettime.php', function(data) {
		$('#time').html(data.time);
	});
}

function makeShape(coords){
	var coordElements = coords.split(';');
	ctx.beginPath();
	for(var i in coordElements){
		if(coordElements[i]){
			var coordType = coordElements[i].substr(0, 1);
			var coords = coordElements[i].substr(1);
			params = coords.split(',');
			switch(coordType){
				case 'M':
					ctx.moveTo(params[0], params[1]);
					break;
				case 'L':
					ctx.lineTo(params[0], params[1]);
					break;
				case 'C':
					ctx.bezierCurveTo(params[0], params[1], params[2], params[3], params[4], params[5]);
					break;
				default:
					break;
			}
		}
	}
	ctx.closePath();
	ctx.fill();
}

