#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/sctp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/types.h>
#include <netdb.h>
#include <pthread.h>
#include <errno.h>

#define BUFFERSIZE 800
#define LOOPS 1

static int sctp_get_asoc_id(int fd)
{
	char *buf;
	int len, asoc_id = 0;

	len = (1 * sizeof(sctp_assoc_t)) + sizeof(uint32_t);
	buf = (char *)malloc(len); 

	if (getsockopt(fd, IPPROTO_SCTP, SCTP_GET_ASSOC_ID_LIST, (void *)buf, (socklen_t *)&len) < 0) {
		perror("    *** setsockopt ***");
		exit(-1);
	}

	asoc_id = ((struct sctp_assoc_ids *)buf)->gaids_assoc_id[0];
	return asoc_id;
}

int sctp_set_enable_strreset(int fd, int asoc_id, int asoc_value)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	params.assoc_value = asoc_value;
	printf("    - sctp_set_enable_strreset Set Asoc ID %d, VA %d\n",
		params.assoc_id, params.assoc_value);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_ENABLE_STREAM_RESET, &params, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
	}
	return 0;
}

int sctp_get_enable_strreset(int fd, int asoc_id)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	result = getsockopt(fd, IPPROTO_SCTP, SCTP_ENABLE_STREAM_RESET, &params, &len);
	if (result < 0) {
		perror("getsockopt");
		exit(-1);
	}
	if (asoc_id)
		printf("    - sctp_get_enable_strreset Get ASOC %x\n", params.assoc_value);
	else
		printf("    - sctp_get_enable_strreset Get EP %x\n", params.assoc_value);
	return 0;
}

int sctp_set_reconf_support(int fd, int asoc_id, int asoc_value)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	params.assoc_value = asoc_value;
	printf("    - sctp_set_reconf_support Set 2 Asoc ID %d, VA %d\n",params.assoc_id,
		params.assoc_value);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_RECONFIG_SUPPORTED, &params, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
	}
	return 0;
}

int sctp_get_reconf_support(int fd, int asoc_id)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	result = getsockopt(fd, IPPROTO_SCTP, SCTP_RECONFIG_SUPPORTED, &params, &len);
	if (result < 0) {
		perror("getsockopt");
		exit(-1);
	}
	if (asoc_id)
		printf("    - sctp_get_reconf_support Get 2 ASOC %d\n", params.assoc_value);
	else
		printf("    - sctp_get_reconf_support Get 2 EP %d\n", params.assoc_value);
	return 0;
}

int sctp_set_strreset_inoutreq_1(int fd, int asoc_id, int asoc_value)
{
	struct sctp_reset_streams params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.srs_assoc_id = asoc_id;
	params.srs_flags = asoc_value;
	params.srs_number_streams = 0;
	printf("    - sctp_set_strreset_inoutreq_1 Set 2 Asoc ID %d, FL %x, VA %d\n",
		params.srs_assoc_id, params.srs_flags, params.srs_number_streams);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_RESET_STREAMS, &params, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
	}
	sleep(3);
	return 0;
}

int sctp_set_strreset_inoutreq_2(int fd, int asoc_id, int asoc_value)
{
	char buffer[sizeof(struct sctp_reset_streams) + 2 * sizeof(uint16_t)];
	struct sctp_reset_streams *params = (struct sctp_reset_streams *)buffer;
	socklen_t len;
	int result;

	len = sizeof(struct sctp_reset_streams) + 2 * sizeof(uint16_t);
	params->srs_assoc_id = asoc_id;
	params->srs_flags = asoc_value;
	params->srs_number_streams = 2;
	params->srs_stream_list[0] = 1;
	params->srs_stream_list[1] = 3;
	printf("    - sctp_set_strreset_inoutreq_2 Set 2 Asoc ID %d, FL %x, VA %d\n",
		params->srs_assoc_id, params->srs_flags, params->srs_number_streams);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_RESET_STREAMS, params, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
	}
	sleep(3);
	return 0;
}

int sctp_set_strreset_assoc(int fd, int asoc_id, int asoc_value)
{
	sctp_assoc_t  assoc_id;
	socklen_t len;
	int result;

	len = sizeof(assoc_id);
	assoc_id = asoc_id;
	printf("    - sctp_set_strreset_assoc Set Asoc ID %d, VA %d\n",assoc_id, 0);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_RESET_ASSOC, &assoc_id, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
		exit(-1);
	}
	sleep(3);
	return 0;
}

int sctp_set_strreset_addstrm(int fd, int asoc_id, int asoc_value_out, int asoc_value_in)
{
	struct sctp_add_streams params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.sas_assoc_id = asoc_id;
	params.sas_instrms = asoc_value_in;
	params.sas_outstrms = asoc_value_out;
	printf("    - sctp_set_strreset_addstrm Set Asoc ID %d, VA %d %d\n",params.sas_assoc_id,
		params.sas_outstrms, params.sas_instrms);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_ADD_STREAMS, &params, len);
	if (result < 0) {
		perror("    *** setsockopt ***");
		exit(-1);
	}
	sleep(3);
	return 0;
}

int sctp_set_strreset_inoutreq_3(int fd, int asoc_id, int asoc_value)
{
        char buffer[sizeof(struct sctp_reset_streams) + 2 * sizeof(uint16_t)];
        struct sctp_reset_streams *params = (struct sctp_reset_streams *)buffer;
        socklen_t len;
        int result;

        len = sizeof(struct sctp_reset_streams) + 2 * sizeof(uint16_t);
        params->srs_assoc_id = asoc_id;
        params->srs_flags = asoc_value;
        params->srs_number_streams = 2;
        params->srs_stream_list[0] = 1;
        params->srs_stream_list[1] = 100;
        printf("    - sctp_set_strreset_inoutreq_2 Set 2 Asoc ID %d, FL %x, VA %d\n",
                params->srs_assoc_id, params->srs_flags, params->srs_number_streams);
        result = setsockopt(fd, IPPROTO_SCTP, SCTP_RESET_STREAMS, params, len);
        if (result < 0) {
                perror("    *** setsockopt ***");
        }
        sleep(3);
	return 0;
}

static int do_perform()
{
	int fd, msg_flags, send_len, recv_len, total_len = 0;
	time_t start, end;
	char addr_str[30];
	char buf[BUFFERSIZE];
	int asoc_id;

	struct sctp_sndrcvinfo sri;
	struct addrinfo *res = NULL;
	struct sockaddr_storage peeraddr;
	socklen_t len = sizeof(peeraddr);

	struct sctp_event_subscribe evnts;
	struct sockaddr_storage addr_cli, addr_ser;

	/*sctp connect*/
	memset(&addr_ser, 0, sizeof(addr_ser));
	sprintf(addr_str, "172.16.%d.%d", 254, 254);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_ser, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_ser))->sin_port = htons(8888);

	memset(&addr_cli, 0, sizeof(addr_cli));
	sprintf(addr_str, "172.16.%d.%d", 2, 2);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_cli, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_cli))->sin_port = htons(8888);

	if ((fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP)) == -1){
		perror("socket");
		exit(-1);
	}
	if (bind(fd, (struct sockaddr *)&addr_cli, res->ai_addrlen) == -1){
		perror("bind");
		exit(-1);
	}
	memset(&evnts, 0, sizeof(evnts));
	evnts.sctp_data_io_event = 1;
	if (setsockopt(fd, IPPROTO_SCTP, SCTP_EVENTS, &evnts,sizeof(evnts)) == -1){
		perror("setsockopt");
		exit(-1);
	}
	if (connect(fd, (struct sockaddr *)&addr_ser, res->ai_addrlen) == -1){
		perror("connect");
		exit(-1);
	}

	start = time(NULL);
	int i = 0, loops=1;
	while(i<loops){

		if ((send_len = sctp_sendmsg(fd, buf, 1, 
			(struct sockaddr *)&addr_ser, res->ai_addrlen, 0, 0, 0, 0, 0)) == -1) {
			perror("sctp_sendmsg");
			exit(-1);
		}
		total_len += send_len;
		i++;
	}
	end = time(NULL);
	printf("time is %lf, send pkt is %d\n", difftime(end, start), total_len);
	sleep(3);

	asoc_id = sctp_get_asoc_id(fd);

	printf("[conformane initial test]\n");
	printf(" ->group 1...\n");
	sctp_get_enable_strreset(fd, asoc_id);
	sctp_get_enable_strreset(fd, 0);
	sctp_set_enable_strreset(fd, asoc_id, SCTP_ENABLE_RESET_STREAM_REQ);
	sctp_get_enable_strreset(fd, asoc_id);
	sctp_get_enable_strreset(fd, 0);
	sctp_set_enable_strreset(fd, 0, SCTP_ENABLE_RESET_STREAM_REQ |
					SCTP_ENABLE_RESET_ASSOC_REQ |
					SCTP_ENABLE_CHANGE_ASSOC_REQ);
	sctp_get_enable_strreset(fd, asoc_id);
	sctp_get_enable_strreset(fd, 0);

	printf(" ->group 2...\n");
	sctp_get_reconf_support(fd, asoc_id);
	sctp_get_reconf_support(fd, 0);
	sctp_set_reconf_support(fd, asoc_id, 1);
	sctp_get_reconf_support(fd, asoc_id);
	sctp_get_reconf_support(fd, 0);
	sctp_set_reconf_support(fd, 0, 1);
	sctp_get_reconf_support(fd, asoc_id);
	sctp_get_reconf_support(fd, 0);

	printf(" ->group 3...\n");
	sctp_set_enable_strreset(fd, asoc_id, SCTP_ENABLE_RESET_ASSOC_REQ |
					      SCTP_ENABLE_CHANGE_ASSOC_REQ);
	sctp_get_enable_strreset(fd, asoc_id);
	sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING);
	sctp_set_enable_strreset(fd, asoc_id, SCTP_ENABLE_RESET_STREAM_REQ |
					      SCTP_ENABLE_RESET_ASSOC_REQ |
					      SCTP_ENABLE_CHANGE_ASSOC_REQ);
	sctp_get_enable_strreset(fd, asoc_id);

	printf("[conformane single test]\n");
	printf(" ->group 1...\n");
	sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING);
	sctp_set_strreset_inoutreq_2(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING);
	sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_INCOMING);
	sctp_set_strreset_inoutreq_2(fd, asoc_id, SCTP_STREAM_RESET_INCOMING);

	printf(" ->group 2...\n");
	sctp_set_strreset_assoc(fd, asoc_id, 2);
	
	printf(" ->group 3...\n");
	sctp_set_strreset_addstrm(fd, asoc_id, 2, 0);
	sctp_set_strreset_addstrm(fd, asoc_id, 0, 2);

	printf("[conformane combination test]\n");
	printf(" ->group 1...\n");
	sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING |
						  SCTP_STREAM_RESET_INCOMING);
	sctp_set_strreset_inoutreq_2(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING |
						  SCTP_STREAM_RESET_INCOMING);

	printf(" ->group 2...\n");
	sctp_set_strreset_addstrm(fd, asoc_id, 2, 2);

	printf("[conformane abnormal test]\n");
	printf(" ->group 1...\n");

        if ((send_len = sctp_sendmsg(fd, buf, 2,
                (struct sockaddr *)&addr_ser, res->ai_addrlen, 0, 0, 0, 0, 0)) == -1) {
                perror("sctp_sendmsg");
                exit(-1);
        }
        sleep(3);
        sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING);
        if ((send_len = sctp_sendmsg(fd, buf, 1,
                (struct sockaddr *)&addr_ser, res->ai_addrlen, 0, 0, 0, 0, 0)) == -1) {
                perror("sctp_sendmsg");
                exit(-1);
        }
        sleep(3);

        printf(" ->group 3...\n");
        if ((send_len = sctp_sendmsg(fd, buf, 2,
                (struct sockaddr *)&addr_ser, res->ai_addrlen, 0, 0, 0, 0, 0)) == -1) {
                perror("sctp_sendmsg");
                exit(-1);
        }
        sleep(3);
        sctp_set_strreset_inoutreq_1(fd, asoc_id, SCTP_STREAM_RESET_INCOMING);
        if ((send_len = sctp_sendmsg(fd, buf, 1,
                (struct sockaddr *)&addr_ser, res->ai_addrlen, 0, 0, 0, 0, 0)) == -1) {
                perror("sctp_sendmsg");
                exit(-1);
        }
        sleep(3);

        printf(" ->group 5...\n");
        // Invalid argument
        sctp_set_strreset_inoutreq_3(fd, asoc_id, SCTP_STREAM_RESET_OUTGOING);

	printf("DONE\n");
	sleep(500);
	close(fd);
	return 0;
}
int main()
{
	printf("\n **** RFC 6525 TEST ****\n\n");
	do_perform();
	printf("\n **** END ****\n\n");
}
