#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pthread.h>
#include <errno.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/sctp.h>

#define BUFFERSIZE 10000
static int sctp_get_asoc_id(int fd)
{
	char *buf;
	int len, asoc_id = 0;

	len = (1 * sizeof(sctp_assoc_t)) + sizeof(uint32_t);
	buf = (char *)malloc(len); 

	if (getsockopt(fd, IPPROTO_SCTP, SCTP_GET_ASSOC_ID_LIST, (void *)buf, (socklen_t *)&len) < 0) {
		perror("setsockopt");
		exit(-1);
	}

	asoc_id = ((struct sctp_assoc_ids *)buf)->gaids_assoc_id[0];
	return asoc_id;
}

int sctp_enable_strreset(int fd, int asoc_id, int asoc_value)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	params.assoc_value = asoc_value;
	printf("  > sctp_enable_strreset Set Asoc ID %d, VA %x\n",
		params.assoc_id, params.assoc_value);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_ENABLE_STREAM_RESET, &params, len);
	if (result < 0) {
		perror("setsockopt");
		exit(-1);
	}
	return 0;
}

int sctp_enable_reconf_support(int fd, int asoc_id, int asoc_value)
{
	struct sctp_assoc_value params;
	socklen_t len;
	int result;

	len = sizeof(params);
	params.assoc_id = asoc_id;
	params.assoc_value = asoc_value;
	printf("  > sctp_enable_reconf_support Set Asoc ID %d, VA %x\n",
		params.assoc_id, params.assoc_value);
	result = setsockopt(fd, IPPROTO_SCTP, SCTP_RECONFIG_SUPPORTED, &params, len);
	if (result < 0) {
		perror("setsockopt");
		exit(-1);
	}
	return 0;
}

int sctp_set_strreset_addstrm(int fd, int asoc_id, int asoc_value_out, int asoc_value_in)
{
        struct sctp_add_streams params;
        socklen_t len;
        int result;

        len = sizeof(params);
        params.sas_assoc_id = asoc_id;
        params.sas_instrms = asoc_value_in;
        params.sas_outstrms = asoc_value_out;
        printf("    - sctp_set_strreset_addstrm Set Asoc ID %d, VA %d %d\n",
                        params.sas_assoc_id, params.sas_outstrms, params.sas_instrms);
        result = setsockopt(fd, IPPROTO_SCTP, SCTP_ADD_STREAMS, &params, len);
        if (result < 0) {
                perror("    *** setsockopt ***");
                exit(-1);
        }
        sleep(3);
	return 0;
}

int main()
{
	int fd, msg_flags, send_len, recv_len, total_len = 0;
	char buf[BUFFERSIZE];
	char addr_str[30];
	int asoc_id;

	struct sctp_sndrcvinfo sri;
	struct addrinfo *res = NULL;
	struct sockaddr_storage peeraddr;
	socklen_t len = sizeof(peeraddr);

	struct sctp_event_subscribe events;
	struct sockaddr_storage addr_cli, addr_ser;

	memset(&addr_ser, 0, sizeof(addr_ser));
	sprintf(addr_str, "172.16.%d.%d", 254, 254);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_ser, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_ser))->sin_port = htons(8888);

	if ((fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP)) == -1){
		perror("socket");
		exit(-1);
	}

	if (bind(fd, (struct sockaddr *)res->ai_addr,res->ai_addrlen) == -1){
		perror("bind");
		exit(-1);
	}

	memset(&events, 0, sizeof(events));
	events.sctp_data_io_event = 1;
	if (setsockopt(fd, IPPROTO_SCTP, SCTP_EVENTS, &events, sizeof(events)) == -1){
		perror("setsockopt");
		exit(-1);
	}

	if (listen(fd, 1000000) == -1){
		perror("listen");
		exit(-1);
	}

	memset(&peeraddr, 0, sizeof(peeraddr));
	asoc_id = SCTP_FUTURE_ASSOC;
	printf("[enable sctp stream reconf]\n");
	sctp_enable_reconf_support(fd, asoc_id, 1);
	//asoc_id = sctp_get_asoc_id(fd);
	//sctp_enable_strreset(fd, asoc_id, SCTP_ENABLE_VALUE_MASK);

	while (1)
	{
		//sctp_recvmsg
		if ((recv_len = sctp_recvmsg(fd, buf, sizeof(buf),
			(struct sockaddr *) &peeraddr, &len, &sri, &msg_flags)) == -1) {
			perror("sctp_recvmsg");
			exit(-1);
		}

		if (recv_len == 1) {
			asoc_id = sctp_get_asoc_id(fd);
			printf("[enable sctp stream reconf] %d\n", recv_len);
			sctp_enable_strreset(fd, asoc_id, SCTP_ENABLE_VALUE_MASK);
		} else if (recv_len == 2) {
			asoc_id = sctp_get_asoc_id(fd);
			printf("[disable sctp stream reconf] %d\n", recv_len);
			sctp_enable_strreset(fd, asoc_id, 0);
		} else if (recv_len == 3) {
			printf("[send sctp stream reconf] %d\n", recv_len);
			sctp_set_strreset_addstrm(fd, asoc_id, 2, 0);
		}

		//sctp_sendmsg
		//if ((send_len = sctp_sendmsg(fd, buf, BUFFERSIZE, 
		//	(struct sockaddr *)&peeraddr, sizeof(peeraddr), 0, 0, 0, 0, 0)) == -1) {
		//	perror("sctp_sendmsg");
		//	exit(-1);
		//}
		total_len += recv_len;
	}
	sleep(10000);
}
