Name="auth_event"
Topo="netns_cs"

do_setup()
{
	modprobe sctp

	st_c_run sysctl -w net.sctp.auth_enable=1
	st_s_run sysctl -w net.sctp.auth_enable=1

	gcc sctp_server.c -o sctp_server -lsctp
	gcc sctp_client.c -o sctp_client -lsctp
	sysctl -w kernel.panic_on_warn=1
}

do_clean()
{
	st_c_run sysctl -w net.sctp.auth_enable=0
	st_s_run sysctl -w net.sctp.auth_enable=0

	rm -rf sctp_server sctp_client *.log
}

do_test()
{
	local logfc="$(st_o)_c.log"
	local logfs="$(st_o)_s.log"
	res=PASS

	st_c_run sysctl -w net.sctp.intl_enable=1
	st_s_run sysctl -w net.sctp.intl_enable=1

	st_s_run ./sctp_server ${st_s_ip4[0]} 8888 >> $logfs 2>&1 &
	sleep 5 

	st_c_run ./sctp_client ${st_s_ip4[0]} 8888 >> $logfc
	st_s_run cat $logfs | grep SCTP_AUTHKEY_EVENT || res=FAIL

	st_log INFO "- $res -" 
	st_s_run pkill sctp_server

	st_c_run sysctl -w net.sctp.intl_enable=0
	st_s_run sysctl -w net.sctp.intl_enable=0

}
