Name="ndatasched"
Topo="netns_cs"

do_setup()
{
	local logfs="$(st_o)_s.log"

	modprobe sctp

	gcc sctp_ndata.c -o sctp_ndata -lsctp
	sysctl -w kernel.panic_on_warn=1
	st_s_run sysctl -w net.sctp.intl_enable=1
	st_s_run ./sctp_ndata 192.0.0.2 8014 1 -l >> $logfs 2>&1 &
	sctp_ndata_pid=$!
}

do_clean()
{
	kill $sctp_ndata_pid
	rm sctp_ndata *.log -rf

	st_s_run sysctl -w net.sctp.intl_enable=0
}

do_test()
{
	st_c_run iptables -F
	st_c_run iptables -A OUTPUT -p sctp -d ${st_s_ip4[0]} --chunk-type only abort -o eth1 -j DROP
	st_c_run python c.py -h ${st_s_ip4[0]} -p 8014 -l ${st_c_ip4[0]}
	st_c_run iptables -F
}
