#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/sctp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/types.h>
#include <netdb.h>
#include <pthread.h>
#include <errno.h>

#define ROW 50
#define NUM 50

#define BUFFERSIZE 1
#define LOOPS 10000000

static int create_assocs()
{
	int fd, i, j, count=0;
	char addr_str[30];
	struct addrinfo *res = NULL;
	struct sctp_event_subscribe evnts;
	struct sockaddr_storage addr_cli, addr_ser;

	memset(&addr_ser, 0, sizeof(addr_ser));
	sprintf(addr_str, "172.16.%d.%d", 254, 254);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_ser, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_ser))->sin_port = htons(8888);

	for(i=1; i<=ROW; i++){
		for(j=1; j<=NUM; j++) {
			memset(&addr_cli, 0, sizeof(addr_cli));
			sprintf(addr_str, "172.16.%d.%d", i, j);
			getaddrinfo(addr_str, "8888", NULL, &res);
			memcpy(&addr_cli, res->ai_addr, res->ai_addrlen);
			((struct sockaddr_in *)(&addr_cli))->sin_port = htons(8888);

			if ((fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP)) == -1){
				perror("socket");
				exit(-1);
			}
			if (bind(fd, (struct sockaddr *)&addr_cli, sizeof(addr_cli)) == -1){
				perror("bind");
				exit(-1);
			}
			memset(&evnts, 0, sizeof(evnts));
			evnts.sctp_data_io_event = 1;
			if (setsockopt(fd, IPPROTO_SCTP, SCTP_EVENTS, &evnts,sizeof(evnts)) == -1){
				perror("setsockopt");
				exit(-1);
			}
			if (connect(fd, (struct sockaddr *)&addr_ser, sizeof(addr_ser)) == -1){
				perror("connect");
				exit(-1);
			}
			//usleep(50000);
			printf("%d\n", ++count);
		}
	}
	return 0;
}
static int do_perform()
{
	int fd, msg_flags, send_len, recv_len, total_len = 0;
	time_t start, end;
	char addr_str[30];
	char buf[BUFFERSIZE];

	struct sctp_sndrcvinfo sri;
	struct addrinfo *res = NULL;
	struct sockaddr_storage peeraddr;
	socklen_t len = sizeof(peeraddr);

	struct sctp_event_subscribe evnts;
	struct sockaddr_storage addr_cli, addr_ser;

	memset(&addr_ser, 0, sizeof(addr_ser));
	sprintf(addr_str, "172.16.%d.%d", 254, 254);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_ser, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_ser))->sin_port = htons(8888);

	memset(&addr_cli, 0, sizeof(addr_cli));
	sprintf(addr_str, "172.16.%d.%d", 253, 253);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_cli, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_cli))->sin_port = htons(8888);

	if ((fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP)) == -1){
		perror("socket");
		exit(-1);
	}
	if (bind(fd, (struct sockaddr *)&addr_cli, sizeof(addr_cli)) == -1){
		perror("bind");
		exit(-1);
	}
	memset(&evnts, 0, sizeof(evnts));
	evnts.sctp_data_io_event = 1;
	if (setsockopt(fd, IPPROTO_SCTP, SCTP_EVENTS, &evnts,sizeof(evnts)) == -1){
		perror("setsockopt");
		exit(-1);
	}
	/* struct sockaddr_in addrs[2];
	 * sctp_assoc_t assoc_id = 345091;
	 * memcpy(&addrs[0], &addr_ser, sizeof(addrs[0]));
	 * if (sctp_connectx(fd, (struct sockaddr *)&addrs, 1, &assoc_id) < 0) {
	 */
	if (connect(fd, (struct sockaddr *)&addr_ser, sizeof(addr_ser)) == -1){
		perror("connect");
		exit(-1);
	}
	printf("sctp connect done\n");
	create_assocs();
	printf("create assocs done\n");

	start = time(NULL);
	int i = 0;
	while(i<LOOPS){
		//sctp_sendmsg
		if ((send_len = sctp_sendmsg(fd, buf, BUFFERSIZE, 
			(struct sockaddr *)&addr_ser, sizeof(addr_ser), 0, 0, 0, 0, 0)) == -1) {
			perror("sctp_sendmsg");
			exit(-1);
		}
		//sctp_recvmsg
		//if ((recv_len = sctp_recvmsg(fd, buf, sizeof(buf),
		//	(struct sockaddr *) &peeraddr, &len, &sri, &msg_flags)) == -1) {
		//	perror("sctp_recvmsg");
		//	exit(-1);
		//}
		total_len += send_len;
		i++;
	}
	end = time(NULL);
	printf("time is %lf, send pkt is %d\n", difftime(end, start), total_len);
	return 0;
}
int main()
{
	do_perform();
}
