#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pthread.h>
#include <netinet/sctp.h>
#include <errno.h>
#include <sys/types.h>
#include <netdb.h>

#define BUFFERSIZE 10000
int main()
{
	int fd, msg_flags, send_len, recv_len, total_len = 0;
	time_t start, end;
	char addr_str[30];
	char buf[BUFFERSIZE];

	struct sctp_sndrcvinfo sri;
	struct addrinfo *res = NULL;
	struct sockaddr_storage peeraddr;
	socklen_t len = sizeof(peeraddr);

	struct sctp_event_subscribe events;
	struct sockaddr_storage addr_cli, addr_ser;

	memset(&addr_ser, 0, sizeof(addr_ser));
	sprintf(addr_str, "172.16.%d.%d", 254, 254);
	getaddrinfo(addr_str, "8888", NULL, &res);
	memcpy(&addr_ser, res->ai_addr, res->ai_addrlen);
	((struct sockaddr_in *)(&addr_ser))->sin_port = htons(8888);

	if ((fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP)) == -1){
		perror("socket");
		exit(-1);
	}

	if (bind(fd, (struct sockaddr *)res->ai_addr,res->ai_addrlen) == -1){
		perror("bind");
		exit(-1);
	}

	memset(&events, 0, sizeof(events));
	events.sctp_data_io_event = 1;
	if (setsockopt(fd, IPPROTO_SCTP, SCTP_EVENTS, &events, sizeof(events)) == -1){
		perror("setsockopt");
		exit(-1);
	}

	if (listen(fd, 1000000) == -1){
		perror("listen");
		exit(-1);
	}

	memset(&peeraddr, 0, sizeof(peeraddr));
	while (1)
	{
		//sctp_recvmsg
		if ((recv_len = sctp_recvmsg(fd, buf, sizeof(buf),
			(struct sockaddr *) &peeraddr, &len, &sri, &msg_flags)) == -1) {
			perror("sctp_recvmsg");
			exit(-1);
		}
		//printf("association id %x\n", sri.sinfo_assoc_id);
		//sctp_sendmsg
		//if ((send_len = sctp_sendmsg(fd, buf, BUFFERSIZE, 
		//	(struct sockaddr *)&peeraddr, sizeof(peeraddr), 0, 0, 0, 0, 0)) == -1) {
		//	perror("sctp_sendmsg");
		//	exit(-1);
		//}
		total_len += recv_len;
	}
	sleep(10000);
}
