﻿/**
See readme.md and tests file to see how it works.
*/
var domain = require('domain'),
    util = require('util');

function toArray(obj) {
  return Array.prototype.slice.call(obj);
}
function bind() {
  var argv = toArray(arguments),
        scope = argv.shift(),
        fn = argv.shift();

  return function () {
    return fn.apply(scope, argv.concat.apply(argv, arguments));
  };
}
//will be called if there is no error listener. it
function abort(err) {
  if (err.stack) {
    console.error(err.stack);
  } else {
    console.error(err);
  }
  process.abort();
}

function Scope(owner) {
  var self = this,
      errorListeners = [],
      unboundListeners = [];

  this.run = function () {
    var argv = toArray(arguments),
        cb = argv.shift(),
        domain = require('domain').create();

    domain.on('error', bind(self, self.error));
    domain.run(function () {
      cb.apply(self, argv);
    });
  };

  //make sure the cb run in this context and, if any error is thrown, the will be caught.
  this.bind = function (cb) {
    return function () {
      return self.run(cb, arguments);
    };
  };

  this.intercept = function () {
    var argv = toArray(arguments),
        cb = argv.shift();

    var obj = this.bind(function () {
      var tmp = toArray(arguments);
      if (tmp.length) {
        var error = tmp.shift();
        return ((error === null) ? self.run(cb, tmp.concat(argv)) : self.error(error));
      }
      return self.run(cb);
    });
    return obj;
  };

  this.addErrorListener = function (errorTypes, cb) {
    var argv = toArray(arguments),
        cb = argv.pop(); //last value is allways assumed to be the callback

    if (argv.length) {
      while (argv.length) {
        errorListeners.push([argv.shift(), cb]);
      }
    } else {
      unboundListeners.push(cb);
    }
    return self;
  };

  this.scope = function() {
    return owner;
  };

  
  this.error = function (err) {
    return onErrorHelper(getErrorListener(err), err, function () {
      if (unboundListeners.length) {
        try {
          unboundListeners.forEach(function (cb) {
            cb(err);
          });
          return;
        } catch (err) {
        }
      }
      var scope = self.scope();
      if (scope) {

        scope.error(err);
      } else {
        abort(err);
      }
    });
  };

  this.create = function () {
    var obj = new Scope(this);
    return obj;
  };

  
  function getErrorListener(err) {
    var obj = [];
    errorListeners.forEach(function (val) {
      if (err instanceof val[0]) {
        obj.push(val[1]);
      }
    });
    return obj;
  }

  function onErrorHelper(listeners, err, next) {
    if (listeners.length) {
      var handler = listeners.shift();
      return handler.call(self, err, function () {
        onErrorHelper(listeners, err, next);
      });
    }
    return next();
  }
}


module.exports = new Scope();