﻿/**
* Simple test file
*/
var util = require('util'),
    assert = require('assert'),
    tests = [];


tests.push(function (domain) {
  var EventEmitter = require('events').EventEmitter,
      result = [];

  domain.addErrorListener(function (err) {
    result.push(err.message);
  });
  domain.addErrorListener(function (err) {
    result.push(err.message + "2");
  });
  domain.run(function () {
    //domain is only created just before run method, therefore everything we want to be catch by the domain
    //must be run within run.
    var event_emitter = new EventEmitter();
    event_emitter.emit('error', new Error("Error"));
  });
  assert.equal(result.length, 2);
  assert.equal(result[0], "Error");
  assert.equal(result[1], "Error2");
});

tests.push(function (domain) {
  assert.ok(typeof domain.addErrorListener === "function");
  assert.ok(typeof domain.error === "function");
  assert.ok(typeof domain.run === "function");
  assert.ok(typeof domain.bind === "function");
  assert.ok(typeof domain.intercept === "function");
  
});

tests.push(function (domain) {
  //those members below does not exist in error-scope objects (as they do in the core module)
  //this is because of the domain is created within the run method. This is wanted bahavior. Otherwise
  //would the error-scope object catch errors even if the run method is never run. This is not as simple
  //as catch all errors within run.
  assert.ok(domain.members === undefined);
  assert.ok(domain.add === undefined);
  assert.ok(domain.remove === undefined);
  assert.ok(domain.dispose === undefined);
});

tests.push(function (domain) {
  //the current domain module (version 8.0) does not allow the user pass extra arguments to the handler
  //through the domain, however the extended version does.
  
  domain.run(assert.equal, 2, 2);
  domain.run(assert.ok, true);
  domain.run(assert.equal, undefined, undefined);
});


tests.push(function (domain) {
  
  var result = [];
  domain.create() //domain will create a new sub-domain
    .run(function () {
      result.push("run");
      //this will be set to the newly created sub-domain, so we can use it to automatic set a eror handler
      this.addErrorListener(Error, function (err, next) {
        assert.ok(err instanceof Error);
        result.push("test1");
        next(); //should call the error-listener the below
      });
      this.addErrorListener(Error, function (err) {
        assert.ok(err instanceof Error);
        result.push("test2");
      });

      setTimeout(function() {
        process.nextTick(function () {
          throw new Error();
        });
      }, 1);
    });
  setTimeout(function () {

    assert.equal(result.length, 3);
    assert.equal(result[0], "run");
    assert.equal(result[1], "test1");
    assert.equal(result[2], "test2");
  }, 20);
});

tests.push(function (domain) {
  var result = [];

  //the user may add multiple handlers in same time
  domain.addErrorListener(Error, EvalError, function (err) {
    //err is a instanceof Error or EvalError
    result.push(err.constructor.name);
  });
  domain.run(function () {
    throw new Error();
  });
  domain.run(function () {
    throw new EvalError();
  });
  assert.equal(result.length, 2);
  assert.equal(result[0], "Error");
  assert.equal(result[1], "EvalError");
  console.error("hihi");
});

//test polymorphism support
tests.push(function (domain) {
  var result = [];

  domain.create()
    .addErrorListener(Error, function (err) {
      assert.ok(err instanceof Error);
      result.push("Error");
      console.error("Error: " + err + " jojo");
    })
    .run(function () {
      function CustomError() {
        Error.apply(this, arguments);
      }
      util.inherits(CustomError, Error);

      this.create()
        .addErrorListener(CustomError, function (err, next) {
          assert.ok(err instanceof CustomError);
          result.push("CustomError");
          //we must invoke next if any more listeners will be called,
          //otherwise is it assumed the error has been handled correcly,
          next();
        })
        .run(function () {
          throw new CustomError("hihi");
        });
    });

  try {
    assert.equal(result.length, 2);
    assert.equal(result[0], "CustomError");
    assert.equal(result[1], "Error2");
  } catch (err) {
    console.error(err);
  }


});



//run all tests
tests.forEach(function (test) {
  test(require('error-scope').create());
});