#include "res_manager.h"
#include <node.h>
#include <v8.h>

using namespace v8;

void tryBlock() {
  int semResource = resourceInit(LOCK_DISPLAY_TOUCH);
  resourceWait(semResource);
  resourcePost(semResource);
}

void Method(const v8::FunctionCallbackInfo<Value>& args) {
  Isolate* isolate = Isolate::GetCurrent();
  HandleScope scope(isolate);
  tryBlock();
  args.GetReturnValue().Set(String::NewFromUtf8(isolate, "world"));
}

void Init(Handle<Object> exports) {
  Isolate* isolate = Isolate::GetCurrent();
  exports->Set(String::NewFromUtf8(isolate, "hello"),
      FunctionTemplate::New(isolate, Method)->GetFunction());
}

NODE_MODULE(hello, Init)

