#!/usr/bin/perl -w
#____________________________________________________________________________
#
#   Obsequeium -- the Internet MP3 Jukebox
#   
#   Copyright (C) 2001 Robert Hart
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#   $Id: html.pl,v 1.0 2001/09/09 01:03:31 enxrah Exp $
#____________________________________________________________________________  

package Obs::Html;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use CGI::Util qw(rearrange make_attributes unescape escape expires);

require Exporter;
require AutoLoader;

@ISA = qw(CGI Exporter AutoLoader);
@EXPORT = qw( );
$VERSION = '0.1.0';

#Basic Colours (Alternative)
#use constant COLBG=> 'white';
#use constant COLTXT=> 'black';
#use constant COLLNK=> 'blue';
#use constant COLVLNK=> '#0000CC';
#use constant COLALNK=> '#000088';

#Table Colours
use constant COLTBLBGH=> '#CCCCCC';
use constant COLTBLBG=> 'white';
use constant COLTBLFGH=> 'red';
use constant COLTBLFG=> 'black';

#Original Basic Colours (comment out Alternative)
use constant COLBG=> '#000000';
use constant COLTXT=> '#FFFFFF';
use constant COLLNK=> '#FF0000';
use constant COLVLNK=> '#E00000';
use constant COLALNK=> '#FFFF00';

#Images
use constant IMGSHOW=> '/obs/images/quest.gif';
use constant IMGADD=> '/obs/images/add.gif';
use constant IMGLOCK=> '/obs/images/blackblock.gif';

use constant SHOW=> 1;
use constant ADD=> 2;
use constant LOCK=> 4;
use constant CHECK=> 8;
use constant NUMBER=> 16;
use constant NAME=> 32;
use constant NAME2=> 64;
use constant TIME=> 128;
use constant TYPE_ART=>256;
use constant TYPE_ALB=>512;
use constant TYPE_TRK=>1024; # default ?
use constant TYPE_LST=>2048;
use constant BOLD=>4096;
use constant DATE=>8192;
use constant COUNT=>16384;
use constant COMMENT=>32768;

#Table Styles
use constant STYLE=> { artist => TYPE_ART | SHOW | NAME ,
		       track => TYPE_ALB | ADD | NUMBER | NAME | TIME,
		       playlist => TYPE_TRK | CHECK | NUMBER | NAME | NAME2 | TIME,
		       pl_lock => TYPE_TRK | LOCK | NUMBER | NAME | NAME2 | TIME,
		       sr_artist => TYPE_ART | SHOW | NAME,
		       sr_album => TYPE_ALB | SHOW | ADD | NAME | NAME2,
		       sr_track => TYPE_TRK | SHOW | ADD | NAME | NAME2 | TIME,
		       history => TYPE_TRK | ADD | NAME | NAME2 | TIME | COMMENT,
		       top100 => TYPE_TRK | ADD | NAME | NAME2 | COUNT,
		       latest => TYPE_TRK | SHOW | ADD | NAME | NAME2 | DATE,
		       chansel => TYPE_LST | SHOW | NAME | COMMENT,
		       listsel => TYPE_LST | SHOW | NAME
		       };

use constant TYPE=> { artist => 0,
		      album => 1,
		      track => 2
		      };
sub nocols{
    my ($o, $style) = @_;
    my $n=0;
    $n++ if ($style & SHOW);
    $n++ if ($style & ADD);
    $n++ if ($style & LOCK);
    $n++ if ($style & CHECK);
    $n++ if ($style & NUMBER);
    $n++ if ($style & NAME);
#    $n++ if ($style & NAME2);
    $n++ if ($style & TIME);
    $n++ if ($style & DATE);
    $n++ if ($style & COUNT);
    $n++ if ($style & COMMENT);
    return $n;
}

sub OBSstart_html{
    my ($o, $title) = @_;
    my (@output);
    push (@output, $o->start_html(-title=>"$title",
				  -text=>COLTXT,
				  -bgcolor=>COLBG,
				  -link=>COLLNK,
				  -vlink=>COLVLNK,
				  -alink=>COLALNK));
    push (@output, "<meta http-equiv=\"pragma\" content=\"no-cache\">\n");
    my $output = join ("\n",@output);
    return $output;

}

sub OBSstart_table{
    my ($o, $style, $title, $total) = @_;
    my (@output);
    my $columns = $o->nocols($style);
    push (@output, 
	  "<table border=0 cellpadding=1 cellspacing=2 width=100%><tr>\n");
    push (@output, "<td colspan=$columns>&nbsp;</td></tr><tr>\n");

    if (!defined($total)){
	push (@output, $o->OBStable_cell($title, $columns, 1));
	push (@output, "</tr>\n");
    }
    else
    {
	push (@output, $o->OBStable_cell($title, $columns-1, 1));
	push (@output, $o->OBStable_cell($total, 1, 1));
	push (@output, "</tr>\n");
    }
    my $output = join("\n", @output) . "\n";
    return $output;
}

sub OBSend_table {
    my ($o) = @_;
    return "</table>\n";
}

sub OBStable_row {
    my ($o, @p) = @_;
    my($id, $number, $name, $name2, $time, $style, $admin, 
       $sched, $anchor, $cbname, $cbchecked, $date, $count, $comment, @other) = 
	rearrange(['ID','NUMBER','NAME','NAME2','TIME','STYLE', 'ADMIN', 
		   'SCHED', 'ANCHOR', 'CBNAME', 'CBCHECKED', 'DATE', 'COUNT', 'COMMENT'],@p);
    my (@output);
    my ($type);
    $type=TYPE->{album} if ($style & TYPE_ALB);
    $type=TYPE->{artist} if ($style & TYPE_ART);
    $type=TYPE->{track} if ($style & TYPE_TRK);
#    print "\n<!--OBStable_row $id $number $name $name2 $time $style $admin 
#$sched $anchor $cbname $cbchecked $date $count $comment -->\n";
    push (@output, "<tr>");
    if (defined($anchor)){
	$anchor="<a name=\"$anchor\">&nbsp</a>";
    }
    else {
	$anchor="";
    }
    if ($style & SHOW){
	push(@output,$o->OBStable_cell($o->OBSbutton_show($id, $sched, $type),1,0,16));
    }
    if ($style & ADD){
	push(@output,$o->OBStable_cell($o->OBSbutton_add($id, $sched, $type),1,0,16));
    }
    if ($style & LOCK){
	push(@output,$o->OBStable_cell($o->OBSbutton_lock($id, $sched),1,0,16));
    }
    if ($style & CHECK){
	push(@output,$o->OBStable_cell($o->OBSbutton_check($id, $cbname, $cbchecked),1,0,16));
    }
    if ($style & NUMBER){
	if ($number==0) {$number="";}
	push (@output, $o->OBStable_cell($number,1,0,20));
    }

#Name (including <a> if in admin mode)
    if ($style & NAME){
	if ($style & NAME2) {
	    $name= "$name -- $name2";
	}
	$name=$o->escapeHTML($name);
	if ($admin){
	    $name="<a target=playlist href=\"edittrack.pl?track=$id\">" .
		$name . "</a>";
	}
	push (@output, $o->OBStable_cell($name . $anchor,1,0,400));
    }

#Time
    if ($style & TIME){
	push (@output, $o->OBStable_cell($time,1,0,40, "right"));
    }

#Date
    if ($style & DATE){
	push (@output, $o->OBStable_cell($date,1,0,40, "right"));
    }

#Comment
    if ($style & COMMENT){
	push (@output, $o->OBStable_cell($comment,1,0,180));
    }

#Count
    if ($style & COUNT){
	push (@output, $o->OBStable_cell($count));
    }

    push (@output, "</tr>");

    my $output = join("\n", @output) . "\n";
    return $output;

}

sub OBSbutton_show {
    my ($o, $id, $sched, $type)=@_;
    my ($href, $target);

    $target="albums";
    $href="album.pl?show=$id";

    $href="$href&sched=on" if ($sched) ;

    return "<a target=$target href=\"$href\">" . 
	"<img src=\"" . IMGSHOW . "\" border=0 alt=\"View\"></a>";
}

sub OBSbutton_add {
    my ($o, $id, $sched, $type)=@_;
    my (@output);
    if ($sched) {
	push (@output, "<a target=editsched href=\"sched/editsched.pl?add=$id\">");
    }
    else
    {
	push (@output, "<a target=playlist href=\"playlist.pl?add=$id\">");
    }
    push (@output, "<img src=\"" . IMGADD . "\" border=0 alt=\"View\"></a>");
    my $output = join ("",@output);
    return $output;
}

sub OBSbutton_lock {
    return "<img src=\"" . IMGLOCK . "\" border=0>"
}

sub OBSbutton_check {
#obviously this wont actually work....
    my ($o, $id, $cbname, $cbchecked) = @_;
    return $o->checkbox(-name=>$cbname, -checked=>$cbchecked, 
			-value=>$id, -label=>"");
}

sub OBStable_cell {
    my ($o, $word, $span, $head, $width, $align) = @_;
    my (@output);
    my ($fg, $bg);
    if ($head){
	$fg = COLTBLFGH;
	$bg = COLTBLBGH;
	if (!defined($align)) {$align ="right";}
    }
    else
    {
	$fg = COLTBLFG;
	$bg = COLTBLBG;
	if (!defined($align)) {$align= "left";}
    }
    if (!defined($span)) {$span=1;}
    if (defined($width)){
	$width=" width=$width";
    }
    else
    { $width="";}
    push (@output, "<td colspan=$span $width bgcolor=\"$bg\" align=$align>");
    push (@output, "<font face=\"helvetica\" color=\"$fg\" size=2>");
    push (@output, "$word</font><br></td>");
    my $output = join("\n", @output) . "\n";
    return $output;
}

1;
__END__

=head1 NAME

Obs::Html - Perl extension for writing HTML

=head1 SYNOPSIS

  use Obs::Html;

  NOTE: This modules is mainly to support the various perl scripts
        that maintain an Obs server.

=head1 DESCRIPTION

  . . .

=head1 AUTHOR

Robert Hart <enxrah@nottingham.ac.uk>

Development of Obsequiuem is sponsored by EMusic.com

=head1 SEE ALSO

perl(1).

=cut
