/**

(c) 2003,2004 Pyerotechnics Development, Inc.
 Release intention to the OJB project at the Apache Foundation.
 Free unrestricted use AS IS by members of the OJB community.


*/
import java.sql.*;
import java.util.*;
import java.io.*;

public class AutoBaseJDBCSchemaDumper
{
 static HashMap s;
 static HashMap p;
 static HashMap o;
 static
 {
  s=new HashMap();
  o=new HashMap();
  p=new HashMap();
  s.put(new Integer(java.sql.Types.ARRAY),"ARRAY");
  s.put(new Integer(java.sql.Types.BIGINT),"BIGINT");
  s.put(new Integer(java.sql.Types.BINARY),"BINARY");
  s.put(new Integer(java.sql.Types.BIT),"BIT");
  s.put(new Integer(java.sql.Types.BLOB),"BLOB");
  s.put(new Integer(java.sql.Types.BOOLEAN),"BOOLEAN");
  s.put(new Integer(java.sql.Types.CHAR),"CHAR");
  s.put(new Integer(java.sql.Types.CLOB),"CLOB");
  s.put(new Integer(java.sql.Types.DATALINK),"DATALINK");
  s.put(new Integer(java.sql.Types.DATE),"DATE");
  s.put(new Integer(java.sql.Types.DECIMAL),"DECIMAL");
  s.put(new Integer(java.sql.Types.DISTINCT),"DISTINCT");
  s.put(new Integer(java.sql.Types.DOUBLE),"DOUBLE");
  s.put(new Integer(java.sql.Types.FLOAT),"FLOAT");
  s.put(new Integer(java.sql.Types.INTEGER),"INTEGER");
  s.put(new Integer(java.sql.Types.JAVA_OBJECT),"JAVA_OBJECT");
  s.put(new Integer(java.sql.Types.LONGVARBINARY),"LONGVARBINARY");
  s.put(new Integer(java.sql.Types.LONGVARCHAR),"LONGVARCHAR");
  s.put(new Integer(java.sql.Types.NULL),"NULL");
  s.put(new Integer(java.sql.Types.NUMERIC),"NUMERIC");
  s.put(new Integer(java.sql.Types.OTHER),"OTHER");
  s.put(new Integer(java.sql.Types.REAL),"REAL");
  s.put(new Integer(java.sql.Types.REF),"REF");
  s.put(new Integer(java.sql.Types.SMALLINT),"SMALLINT");
  s.put(new Integer(java.sql.Types.STRUCT),"STRUCT");
  s.put(new Integer(java.sql.Types.TIME),"TIME");
  s.put(new Integer(java.sql.Types.TIMESTAMP),"TIMESTAMP");
  s.put(new Integer(java.sql.Types.TINYINT),"TINYINT");
  s.put(new Integer(java.sql.Types.VARBINARY),"VARBINARY");
  s.put(new Integer(java.sql.Types.VARCHAR),"VARCHAR");
  p.put(new Integer(java.sql.Types.ARRAY),"Array");
  p.put(new Integer(java.sql.Types.BIGINT),"long");
  p.put(new Integer(java.sql.Types.BINARY),"byte[]");
  p.put(new Integer(java.sql.Types.BIT),"boolean");
  p.put(new Integer(java.sql.Types.BLOB),"Blob");
  p.put(new Integer(java.sql.Types.BOOLEAN),"boolean");
  p.put(new Integer(java.sql.Types.CHAR),"String");
  p.put(new Integer(java.sql.Types.CLOB),"Clob");
  p.put(new Integer(java.sql.Types.DATALINK),"?");
  p.put(new Integer(java.sql.Types.DATE),"java.sql.Date");
  p.put(new Integer(java.sql.Types.DECIMAL),"java.math.BigDecimal");
  p.put(new Integer(java.sql.Types.DISTINCT),"??");
  p.put(new Integer(java.sql.Types.DOUBLE),"double");
  p.put(new Integer(java.sql.Types.FLOAT),"double");
  p.put(new Integer(java.sql.Types.INTEGER),"int");
  p.put(new Integer(java.sql.Types.JAVA_OBJECT),"???");
  p.put(new Integer(java.sql.Types.LONGVARBINARY),"byte[]");
  p.put(new Integer(java.sql.Types.LONGVARCHAR),"String");
  p.put(new Integer(java.sql.Types.NULL),"????");
  p.put(new Integer(java.sql.Types.NUMERIC),"java.math.BigDecimal");
  p.put(new Integer(java.sql.Types.OTHER),"?????");
  p.put(new Integer(java.sql.Types.REAL),"float");
  p.put(new Integer(java.sql.Types.REF),"Ref");
  p.put(new Integer(java.sql.Types.SMALLINT),"short");
  p.put(new Integer(java.sql.Types.STRUCT),"Struct");
  p.put(new Integer(java.sql.Types.TIME),"java.sql.Time");
  p.put(new Integer(java.sql.Types.TIMESTAMP),"java.sql.Timestamp");
  p.put(new Integer(java.sql.Types.TINYINT),"byte");
  p.put(new Integer(java.sql.Types.VARBINARY),"byte[]");
  p.put(new Integer(java.sql.Types.VARCHAR),"String");
  o.put(new Integer(java.sql.Types.ARRAY),"Array");
  o.put(new Integer(java.sql.Types.BIGINT),"Long");
  o.put(new Integer(java.sql.Types.BINARY),"byte[]");
  o.put(new Integer(java.sql.Types.BIT),"Boolean");
  o.put(new Integer(java.sql.Types.BLOB),"Blob");
  o.put(new Integer(java.sql.Types.BOOLEAN),"Boolean");
  o.put(new Integer(java.sql.Types.CHAR),"String");
  o.put(new Integer(java.sql.Types.CLOB),"Clob");
  o.put(new Integer(java.sql.Types.DATALINK),"?");
  o.put(new Integer(java.sql.Types.DATE),"java.sql.Date");
  o.put(new Integer(java.sql.Types.DECIMAL),"java.math.BigDecimal");
  o.put(new Integer(java.sql.Types.DISTINCT),"??");
  o.put(new Integer(java.sql.Types.DOUBLE),"Double");
  o.put(new Integer(java.sql.Types.FLOAT),"Double");
  o.put(new Integer(java.sql.Types.INTEGER),"Integer");
  o.put(new Integer(java.sql.Types.JAVA_OBJECT),"???");
  o.put(new Integer(java.sql.Types.LONGVARBINARY),"byte[]");
  o.put(new Integer(java.sql.Types.LONGVARCHAR),"String");
  o.put(new Integer(java.sql.Types.NULL),"????");
  o.put(new Integer(java.sql.Types.NUMERIC),"java.math.BigDecimal");
  o.put(new Integer(java.sql.Types.OTHER),"?????");
  o.put(new Integer(java.sql.Types.REAL),"Float");
  o.put(new Integer(java.sql.Types.REF),"Ref");
  o.put(new Integer(java.sql.Types.SMALLINT),"Integer");
  o.put(new Integer(java.sql.Types.STRUCT),"SQLData");
  o.put(new Integer(java.sql.Types.TIME),"java.sql.Time");
  o.put(new Integer(java.sql.Types.TIMESTAMP),"java.sql.Timestamp");
  o.put(new Integer(java.sql.Types.TINYINT),"Integer");
  o.put(new Integer(java.sql.Types.VARBINARY),"byte[]");
  o.put(new Integer(java.sql.Types.VARCHAR),"String");

 }


 public static String encode(String str)
 {
  str=str.replaceAll("&","&amp;");
  str=str.replaceAll("<","&lt;");
  str=str.replaceAll(">","&gt;");
  str=str.replaceAll("'","&apos;");
  str=str.replaceAll("\"","&quot;");
  return str;
 }

 public static String primitiveType(int k)
 {
  return String.valueOf(p.get(new Integer(k)));
 }

 public static String objectType(int k)
 {
  return String.valueOf(o.get(new Integer(k)));
 }

 public static String sqlType(int k)
 {
  return String.valueOf(s.get(new Integer(k)));
 }

 public static void dumpCatalogs(String ident, DatabaseMetaData dmd, PrintStream out) throws Throwable
 {
  ResultSet rs=dmd.getCatalogs();
  out.println(ident+"<catalogs>");
  while(rs.next())
  {
   out.println(ident+" <catalog TABLE_CAT='"+encode(rs.getString("TABLE_CAT"))+"' />");
  }
  out.println(ident+"</catalogs>");
  rs.close();
 }

 public static void dumpSchemas(String ident, DatabaseMetaData dmd, PrintStream out) throws Throwable
 {
  ResultSet rs=dmd.getSchemas();
  out.println(ident+"<schemas>");
  while(rs.next())
  {
   out.println(ident+" <schema TABLE_SCHEM='"+encode(rs.getString("TABLE_SCHEM"))+"' />");
  }
  out.println(ident+"</schemas>");
  rs.close();
 }

 public static void dumpTables(String ident, DatabaseMetaData dmd, PrintStream out) throws Throwable
 {
  ResultSet rs=dmd.getTables(null,null,null,null);
  out.println(ident+"<tables>");
  while(rs.next())
  {
   out.print(ident+" <table");

   String cat;
   String sch;
   String tab;
   String data;

   cat=data=rs.getString("TABLE_CAT");   if (data!=null && !data.trim().equals("")) out.print(" TABLE_CAT='"+encode(data)+"'");
   sch=data=rs.getString("TABLE_SCHEM"); if (data!=null && !data.trim().equals("")) out.print(" TABLE_SCHEM='"+encode(data)+"'");
   tab=data=rs.getString("TABLE_NAME");  if (data!=null && !data.trim().equals("")) out.print(" TABLE_NAME='"+encode(data)+"'");
       data=rs.getString("TABLE_TYPE");  if (data!=null && !data.trim().equals("")) out.print(" TABLE_TYPE='"+encode(data)+"'");
       data=rs.getString("REMARKS");     if (data!=null && !data.trim().equals("")) out.print(" REMARKS='"+encode(data)+"'");

   out.println(">");

   dumpColumns(ident+"  ",dmd,out,cat,sch,tab);
   dumpIndicies(ident+"  ",dmd,out,cat,sch,tab);
   dumpKeys(ident+"  ",dmd,out,cat,sch,tab);

   out.println(ident+" </table>");
  }
  out.println(ident+"</tables>");
  rs.close();
 }

 public static void dumpColumns(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getColumns(cat,sch,tab,null);
  out.println(ident+"<columns>");
  while(rs.next())
  {
   out.print(ident+" <column");

   String data;
   data=rs.getString("COLUMN_NAME");           if (data!=null && !data.trim().equals("")) out.print(" COLUMN_NAME='"+encode(data)+"'");
   data=rs.getString("COLUMN_NAME");           if (data!=null && !data.trim().equals(""))
   {
    String f=data.substring(0,1).toUpperCase();
    String l=data.substring(1);
    data=f+l;
    out.print(" columnNameHacked='"+encode(data)+"'");
   }
   data=rs.getString("TYPE_NAME");             if (data!=null && !data.trim().equals("")) out.print(" TYPE_NAME='"+encode(data)+"'");
   data=rs.getString("COLUMN_SIZE");           if (data!=null && !data.trim().equals("")) out.print(" COLUMN_SIZE='"+encode(data)+"'");
   data=rs.getString("BUFFER_LENGTH");         if (data!=null && !data.trim().equals("")) out.print(" BUFFER_LENGTH='"+encode(data)+"'");
   data=rs.getString("DECIMAL_DIGITS");        if (data!=null && !data.trim().equals("")) out.print(" DECIMAL_DIGITS='"+encode(data)+"'");
   data=rs.getString("NUM_PREC_RADIX");        if (data!=null && !data.trim().equals("")) out.print(" NUM_PREC_RADIX='"+encode(data)+"'");
   data=rs.getString("DATA_TYPE");             if (data!=null && !data.trim().equals("")) out.print(" DATA_TYPE='"+encode(data)+"'");
   data=rs.getString("IS_NULLABLE");           if (data!=null && !data.trim().equals("")) out.print(" IS_NULLABLE='"+encode(data)+"'");
   data=rs.getString("ORDINAL_POSITION");      if (data!=null && !data.trim().equals("")) out.print(" ORDINAL_POSITION='"+encode(data)+"'");
   data=rs.getString("CHAR_OCTET_LENGTH");     if (data!=null && !data.trim().equals("")) out.print(" CHAR_OCTET_LENGTH='"+encode(data)+"'");
   data=rs.getString("SQL_DATETIME_SUB");      if (data!=null && !data.trim().equals("")) out.print(" SQL_DATETIME_SUB='"+encode(data)+"'");
   data=rs.getString("SQL_DATA_TYPE");         if (data!=null && !data.trim().equals("")) out.print(" SQL_DATA_TYPE='"+encode(data)+"'");
   data=rs.getString("COLUMN_DEF");            if (data!=null && !data.trim().equals("")) out.print(" COLUMN_DEF='"+encode(data)+"'");
   data=rs.getString("REMARKS");               if (data!=null && !data.trim().equals("")) out.print(" REMARKS='"+encode(data)+"'");
   data=rs.getString("NULLABLE");              if (data!=null && !data.trim().equals("")) out.print(" NULLABLE='"+encode(data)+"'");
   data=primitiveType(rs.getInt("DATA_TYPE")); if (data!=null && !data.trim().equals("")) out.print(" primitiveType='"+encode(data)+"'");
   data=objectType(rs.getInt("DATA_TYPE"));    if (data!=null && !data.trim().equals("")) out.print(" objectType='"+encode(data)+"'");
   data=sqlType(rs.getInt("DATA_TYPE"));       if (data!=null && !data.trim().equals("")) out.print(" sqlType='"+encode(data)+"'");

   out.println("/>");
  }
  out.println(ident+"</columns>");
  rs.close();
 }

 public static void dumpIndicies(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getIndexInfo(cat,sch,tab,false,true);
  out.println(ident+"<indicies>");
  if (rs.next())
  {
   out.print(ident+" <index");

   String data;

   data=rs.getString("NON_UNIQUE");       if (data!=null && !data.trim().equals("")) out.print(" NON_UNIQUE='"+encode(data)+"'");
   data=rs.getString("INDEX_QUALIFIER");  if (data!=null && !data.trim().equals("")) out.print(" INDEX_QUALIFIER='"+encode(data)+"'");
   data=rs.getString("INDEX_NAME");       if (data!=null && !data.trim().equals("")) out.print(" INDEX_NAME='"+encode(data)+"'");
   data=rs.getString("TYPE");             if (data!=null && !data.trim().equals("")) out.print(" TYPE='"+encode(data)+"'");
   data=rs.getString("PAGES");            if (data!=null && !data.trim().equals("")) out.print(" PAGES='"+encode(data)+"'");
   data=rs.getString("FILTER_CONDITION"); if (data!=null && !data.trim().equals("")) out.print(" FILTER_CONDITION='"+encode(data)+"'");

   out.println(">");


   rs.beforeFirst();

   while (rs.next())
   {
    out.print(ident+"  <indexcolumn");

    data=rs.getString("COLUMN_NAME");      if (data!=null && !data.trim().equals("")) out.print(" COLUMN_NAME='"+encode(data)+"'");
   data=rs.getString("COLUMN_NAME");           if (data!=null && !data.trim().equals(""))
   {
    String f=data.substring(0,1).toUpperCase();
    String l=data.substring(1);
    data=f+l;
    out.print(" columnNameHacked='"+encode(data)+"'");
   }
    data=rs.getString("ORDINAL_POSITION"); if (data!=null && !data.trim().equals("")) out.print(" ORDINAL_POSITION='"+encode(data)+"'");
    data=rs.getString("CARDINALITY");      if (data!=null && !data.trim().equals("")) out.print(" CARDINALITY='"+encode(data)+"'");
    data=rs.getString("ASC_OR_DESC");      if (data!=null && !data.trim().equals("")) out.print(" ASC_OR_DESC='"+encode(data)+"'");

    out.println("/>");
   }


   out.println(ident+" </index>");

  }
  out.println(ident+"</indicies>");
  rs.close();
 }

 public static void dumpKeys(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getIndexInfo(cat,sch,tab,false,true);
  out.println(ident+"<keys>");
  dumpPKeys(ident+" ",dmd,out,cat,sch,tab);
  dumpFKeys(ident+" ",dmd,out,cat,sch,tab);
  dumpIKeys(ident+" ",dmd,out,cat,sch,tab);
  out.println(ident+"</keys>");
  rs.close();
 }

 public static void dumpPKeys(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getPrimaryKeys(cat,sch,tab);
  if (rs.next())
  {
   out.print(ident+"<pk");

   String data;

   data=rs.getString("PK_NAME"); if (data!=null && !data.trim().equals("")) out.print(" PK_NAME='"+encode(data)+"'");

   out.println(">");

   rs.beforeFirst();

   while (rs.next())
   {
    out.print(ident+" <pkcolumn");

    data=rs.getString("COLUMN_NAME"); if (data!=null && !data.trim().equals("")) out.print(" COLUMN_NAME='"+encode(data)+"'");
    data=rs.getString("COLUMN_NAME");           if (data!=null && !data.trim().equals(""))
    {
     String f=data.substring(0,1).toUpperCase();
     String l=data.substring(1);
     data=f+l;
     out.print(" columnNameHacked='"+encode(data)+"'");
    }
    data=rs.getString("KEY_SEQ");     if (data!=null && !data.trim().equals("")) out.print(" KEY_SEQ='"+encode(data)+"'");

    out.println("/>");
   }
   out.println(ident+"</pk>");
  }
  rs.close();
 }

 public static void attrMapPut(Map m, ResultSet rs, String attr) throws Throwable
 {
  String data=rs.getString(attr);
  if (data != null && !data.trim().equals("")) data=encode(data);
  m.put(attr, data);
 }

 public static final int HACK_NAME=1;
 public static void attrMapPut(Map m, ResultSet rs, String attr, String src, int hack) throws Throwable
 {
  String data=rs.getString(src);
  if (data != null && !data.trim().equals(""))
  {
   if (hack==HACK_NAME)
   {
    String f=data.substring(0,1).toUpperCase();
    String l=data.substring(1);
    data=f+l;
   }
   data=encode(data);
  }
  m.put(attr, data);
 }

 public static class Element extends HashMap
 {
  Set children=new HashSet();
  public Set getChildren(){return children;}
  public void addChild(Element o){children.add(o);}
 }

 public static void dumpAttrs(PrintStream out, Element el)
 {
  Iterator i=el.keySet().iterator();
  while (i.hasNext())
  {
   String attr=(String)i.next();
   String value=(String)el.get(attr);
   if (value!=null) out.print(" "+attr+"='"+value+"'");
  }
 }

 public static void dumpFKeys(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getImportedKeys(cat,sch,tab);
  HashMap map=new HashMap();
  while (rs.next())
  {
   Element key=new Element();
   attrMapPut(key,rs,"FK_NAME");
   attrMapPut(key,rs,"PKTABLE_NAME");
   attrMapPut(key,rs,"PKTABLE_CAT");
   attrMapPut(key,rs,"PKTABLE_SCHEM");
   attrMapPut(key,rs,"DEFERRABILITY");
   attrMapPut(key,rs,"UPDATE_RULE");
   attrMapPut(key,rs,"DELETE_RULE");

   {
    Object cache=map.get(key);
    if (cache==null)
     map.put(key,key);
    else
     key=(Element)cache;
   }

   Element subkey=new Element();
   key.addChild(subkey);

   attrMapPut(subkey,rs,"PKCOLUMN_NAME");
   attrMapPut(subkey,rs,"pkcolumnNameHacked","PKCOLUMN_NAME",HACK_NAME);
   attrMapPut(subkey,rs,"FKCOLUMN_NAME");
   attrMapPut(subkey,rs,"fkcolumnNameHacked","FKCOLUMN_NAME",HACK_NAME);
   attrMapPut(subkey,rs,"KEY_SEQ");

  }

  rs.close();

  Iterator i=map.keySet().iterator();
  while (i.hasNext())
  {
   Element key=(Element)i.next();
   out.print(ident+"<fk");
   dumpAttrs(out,key);
   out.println(">");

   Set subkeys=key.getChildren();

   Iterator ii=subkeys.iterator();

   while (ii.hasNext())
   {
    Element subkey=(Element)ii.next();
    out.print(ident+" <fkcolumn");
    dumpAttrs(out,subkey);
    out.println("/>");
   }

   out.println(ident+"</fk>");
  }

 }

 public static void dumpIKeys(String ident, DatabaseMetaData dmd, PrintStream out, String cat, String sch, String tab) throws Throwable
 {
  ResultSet rs=dmd.getExportedKeys(cat,sch,tab);
  HashMap map=new HashMap();
  while (rs.next())
  {
   Element key=new Element();
   attrMapPut(key,rs,"FK_NAME");
   attrMapPut(key,rs,"FKTABLE_NAME");
   attrMapPut(key,rs,"FKTABLE_CAT");
   attrMapPut(key,rs,"FKTABLE_SCHEM");
   attrMapPut(key,rs,"DEFERRABILITY");
   attrMapPut(key,rs,"UPDATE_RULE");
   attrMapPut(key,rs,"DELETE_RULE");

   {
    Object cache=map.get(key);
    if (cache==null)
     map.put(key,key);
    else
     key=(Element)cache;
   }

   Element subkey=new Element();
   key.addChild(subkey);

   attrMapPut(subkey,rs,"PKCOLUMN_NAME");
   attrMapPut(subkey,rs,"pkcolumnNameHacked","PKCOLUMN_NAME",HACK_NAME);
   attrMapPut(subkey,rs,"FKCOLUMN_NAME");
   attrMapPut(subkey,rs,"fkcolumnNameHacked","FKCOLUMN_NAME",HACK_NAME);
   attrMapPut(subkey,rs,"KEY_SEQ");

  }

  rs.close();

  Iterator i=map.keySet().iterator();
  while (i.hasNext())
  {
   Element key=(Element)i.next();
   out.print(ident+"<ik");
   dumpAttrs(out,key);
   out.println(">");

   Set subkeys=key.getChildren();

   Iterator ii=subkeys.iterator();

   while (ii.hasNext())
   {
    Element subkey=(Element)ii.next();
    out.print(ident+" <ikcolumn");
    dumpAttrs(out,subkey);
    out.println("/>");
   }

   out.println(ident+"</ik>");
  }

 }

 static String password;
 static String user;
 public static void dumpDatabaseMetaData(String ident, DatabaseMetaData dmd, PrintStream out) throws Throwable
 {
  out.println("<?xml version='1.0'?>");
  out.println("<!DOCTYPE greeting SYSTEM 'AutoBaseJDBCSchema.dtd'>");

  out.print(ident+"<databaseMetaData");

  String data;

  data=dmd.getURL();                    if (data!=null && !data.trim().equals("")) out.print(" URL='"+encode(data)+"'");
  Driver drv=DriverManager.getDriver(data); if (drv!=null) out.print(" driverClass='"+encode(drv.getClass().getName())+"'");
  data=dmd.getDatabaseProductName();    if (data!=null && !data.trim().equals("")) out.print(" databaseProductName='"+encode(data)+"'");
  data=dmd.getDatabaseProductVersion(); if (data!=null && !data.trim().equals("")) out.print(" databaseProductVersion='"+encode(data)+"'");
  data=dmd.getDriverName();             if (data!=null && !data.trim().equals("")) out.print(" driverName='"+encode(data)+"'");
  data=dmd.getDriverVersion();          if (data!=null && !data.trim().equals("")) out.print(" driverVersion='"+encode(data)+"'");
  data=user;                            if (data!=null && !data.trim().equals("")) out.print(" userName='"+encode(data)+"'");
  data=password;                        if (data!=null && !data.trim().equals("")) out.print(" password='"+encode(data)+"'");

  out.println(">");

  dumpCatalogs(ident+" ",dmd,out);
  dumpSchemas(ident+" ",dmd,out);
  dumpTables(ident+" ",dmd,out);

  out.println(ident+"</databaseMetaData>");
 }

 public static void main(String[] args) throws Throwable
 {
  if (args.length==0)
  {
   System.err.println("usage: java [-Djdbc.drivers=path:path:path] DumpDatabase url [user [pass]]");
   return;
  }
  Connection C=DriverManager.getConnection(args[0],user=args.length>1?args[1]:null,password=args.length>2?args[2]:null);
  DatabaseMetaData dmd=C.getMetaData();
  dumpDatabaseMetaData("", dmd,System.out);
  C.close();
 }
}