<?xml version="1.0"?>
<!-- (c) 2003,2004 Pyerotechnics Development, Inc. -->
<!-- Release intention to the OJB project at the Apache Foundation.
  -- Free unrestricted use AS IS by members of the OJB community.
  -->
<!-- don't forget to define AutoBasePackage -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
 <xsl:output method="xml" indent="yes" />
<xsl:param name="AutoBasePackage">test.dataobjects</xsl:param>
<xsl:param name = "sequence-manager" />
<xsl:param name = "object-cache" />
<!-- <xsl:param name = "AutoBasePackage" select="'test'" /> -->

 <xsl:template match="databaseMetaData">
  <!-- isolation-level="read-uncommitted" proxy-prefetching-limit="50"> -->
  <xsl:element name='jdbc-connection-descriptor'>
   <xsl:attribute name='jcd-alias'>default</xsl:attribute>
   <xsl:attribute name='default-connection'>true</xsl:attribute>
   <xsl:attribute name='platform'><xsl:value-of select="@databaseProductName"/></xsl:attribute>
   <xsl:attribute name='jdbc-level'>2.0</xsl:attribute>
   <xsl:attribute name='driver'><xsl:value-of select="@driverClass"/></xsl:attribute>
   <xsl:attribute name='protocol'><xsl:value-of select="substring-before(@URL, ':')" /></xsl:attribute>
   <xsl:attribute name='subprotocol'><xsl:value-of select="substring-before(substring-after(@URL, ':'),':')" /></xsl:attribute>
   <xsl:attribute name='dbalias'><xsl:value-of select="substring-after(substring-after(@URL, ':'),':')" /></xsl:attribute>
   <xsl:if test="@userName"><xsl:attribute name='username'><xsl:value-of select="@userName"/></xsl:attribute></xsl:if>
   <xsl:if test="@password"><xsl:attribute name='password'><xsl:value-of select="@password"/></xsl:attribute></xsl:if>
  </xsl:element>

  <!-- sequence-manager -->

  <xsl:if test="$sequence-manager">
   <sequence-manager className="{$sequence-manager}" />
  </xsl:if>

  <!-- object-cache -->

  <xsl:if test="$object-cache">
   <object-cache class="{$object-cache}" />
  </xsl:if>

  <xsl:apply-templates/>
 </xsl:template>

 <xsl:template match="/">
  <descriptor-repository version="1.0">
  <xsl:apply-templates/>
  </descriptor-repository>
 </xsl:template>
 <xsl:template match="tables">
  <xsl:for-each select="table">
 <class-descriptor table="{@TABLE_NAME}" class="{$AutoBasePackage}.{@TABLE_NAME}">
  <xsl:for-each select="columns/column">

   <xsl:element name='field-descriptor'>
    <xsl:attribute name='name'><xsl:value-of select="@COLUMN_NAME"/></xsl:attribute>
    <xsl:attribute name='column'><xsl:value-of select="@COLUMN_NAME"/></xsl:attribute>
    <xsl:attribute name='jdbc-type'><xsl:value-of select="@sqlType"/></xsl:attribute>
    <xsl:if test="../../keys/pk/pkcolumn/@COLUMN_NAME=@COLUMN_NAME">
     <xsl:attribute name='primarykey'>true</xsl:attribute>
    </xsl:if>
    <xsl:if test="contains(@REMARKS,'auto_increment') ">
     <xsl:attribute name='autoincrement'>true</xsl:attribute>
    </xsl:if>
   </xsl:element>
  </xsl:for-each>

   <xsl:for-each select="keys/fk">
    <xsl:element name='reference-descriptor'>
     <!-- the is going to be a bug if there are multiple columns in the mapping -->
     <xsl:attribute name='name'><xsl:value-of select="fkcolumn/@FKCOLUMN_NAME"/>Obj</xsl:attribute>
     <xsl:attribute name='class-ref'><xsl:value-of select="$AutoBasePackage"/>.<xsl:value-of select="../../@TABLE_NAME"/></xsl:attribute>
      <xsl:for-each select="fkcolumn">
       <foreignkey field-ref="{@FKCOLUMN_NAME}" />
      </xsl:for-each>
    </xsl:element>
   </xsl:for-each>

   <xsl:for-each select="keys/ik/ikcolumn">
    <!-- todo M:N collections -->
    <xsl:element name='collection-descriptor'>
     <xsl:attribute name='name'><xsl:value-of select="@FKCOLUMN_NAME"/>_<xsl:value-of select="../@FKTABLE_NAME"/>Collection</xsl:attribute>
     <xsl:attribute name='element-class-ref'><xsl:value-of select="$AutoBasePackage"/>.<xsl:value-of select="../../../@TABLE_NAME"/></xsl:attribute>
      <inverse-foreignkey field-ref="{@FKCOLUMN_NAME}"/>
    </xsl:element>
   </xsl:for-each>

 </class-descriptor>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>

<!--


  *<collection-descriptor name="AttorneyAccountMap"
                          element-class-ref="com.pyerotechnics.customer.atlanticlock.rejistore.locksmith.tier1.dataobjects.AttorneyAccountMap">
   <inverse-foreignkey field-ref="accountRef"/>
  </collection-descriptor>
-->
