import openbabel as ob

ob.obErrorLog.SetOutputLevel(0)

conv = ob.OBConversion()
conv.SetInAndOutFormats('pdb', 'pdb')

r = ob.OBMol()
t = ob.OBMol()

conv.ReadFile(r, 'r.pdb')
conv.ReadFile(t, 't.pdb')

shift = r.GetAtom(1).GetVector()

# the following line triggers the bug
shift -= t.GetAtom(1).GetVector()


# possible work around
# v1 = r.GetAtom(1).GetVector()
# v2 = t.GetAtom(1).GetVector()

# x = v1.GetX() - v2.GetX()
# y = v1.GetY() - v2.GetY()
# z = v1.GetZ() - v2.GetZ()

# shift = ob.vector3(x, y, z)
