
use strict;

require "config.pl";

opendir DIR, "." or die "Cannot open test directory.\n";
my @majorlist = grep /[0-9]+/, readdir DIR;
closedir DIR;

foreach my $dir (sort @majorlist)
{
    print STDERR "Test sequence $dir ...\n";
    $ENV{TESTPID} = $$;
    print STDERR "    TESTPID $$\n";

    ## 1. Phase: installation of the software

    print STDERR "    Installing the software (see install.log) ...\n";

    rename $ENV{SRCDIR}, $ENV{SRCDIR}.".bak" if (-e $ENV{SRCDIR});
    mkdir $ENV{SRCDIR};
    my $home = `pwd`;
    $home = substr $home, 0, length($home)-1;

    unlink ("$dir/install.log");
    my $install_script = "";
    my @sequence = (
        "cp $dir/configure.in.sh \$SRCDIR/",
        "cd \$CVSDIR",
        "tar -cf - openca-0.9 | tar -xf - -C \$SRCDIR",
        "cd \$SRCDIR/openca-0.9",
        "sh ../configure.in.sh",
        "make",
        "make install",
        "cd $home",
        "cat \$OPENCA_ETC/config.xml",
        "sed -f $dir/config.xml.sed \$OPENCA_ETC/config.xml > tmp.xml",
        "cat tmp.xml",
        "mv tmp.xml \$OPENCA_ETC/config.xml",
        "cat \$OPENCA_ETC/config.xml",
        "cd \$OPENCA_ETC",
        "sh configure_etc.sh");
    foreach my $cmd (@sequence)
    {
        $install_script .= "echo SCRIPT COMMAND: '$cmd' >> $home/$dir/install.log; ".
                           "$cmd";
        if (index($cmd, ">") < 0)
        {
            $install_script .= " 2>&1 >> $home/$dir/install.log; ";
        } else {
            $install_script .= " 2>> $home/$dir/install.log; ";
        }
    }
    `$install_script`;

    ## 2. Phase: start OpenCA

    # do not use backticks here, they have a problem with forking processes
    print "    ";
    system $ENV{OPENCA_ETC}."/openca_rc", "start", "2>&1", ">>$home/$dir/install.log";

    ## 3. Phase: run the test sequence

    opendir DIR, $dir or die "Cannot open directory $dir.\n";
    my @minorlist = grep /^[0-9]+\.sh$/, readdir DIR;
    closedir DIR;

    ## pre
    print STDERR "    Init test ...\n";
    `CLIENT=\${BINDIR}/openca-shell-client . $dir/pre.sh`;

    ## execute tests
    foreach my $test (@minorlist)
    {
        print "    Test $test ... ";
        my $output = `CLIENT=\${BINDIR}/openca-shell-client . $dir/$test`;
        if ($output =~ /OPENCA_I18N_UI_SHELL_CLIENT_FAILURE/)
        {
            open FD, ">$dir/$test.protocol" or die "Cannot open error log $dir/$test.protocol.\n";
            print FD $output;
            close FD;
            print STDERR "FAILED\n";
            last;
        } else {
            print STDERR "OK\n";
        }
    }

    ## post
    print STDERR "    Cleanup test ...\n";
    `CLIENT=\${BINDIR}/openca-shell-client . $dir/post.sh`;


    ## 5. Phase: stop OpenCA

    print STDERR "    Stopping OpenCA and remove software from system ...\n";
    `\$OPENCA_ETC/openca_rc stop`;
    foreach my $waste ($ENV{OPENCA_PREFIX}, $ENV{SRCDIR})
    {
        next if ($waste =~ /\s/);              ## no blanks
        next if (length ($waste) < 8);         ## pathlength must be "/tmp/tmp" at minimum
        next if ($waste !~ /\/[^\]+\/[^\/]+/); ## no toplevel directories
        `rm -rf $waste`;
    }

    print STDERR "Test sequence $dir completed.\n";
}
