# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-perl/CGI-Session/CGI-Session-3.95.ebuild,v 1.2 2005/05/24 15:34:01 mcummings Exp $

inherit eutils gnuconfig

DESCRIPTION="OpenCA Certification Authority"
HOMEPAGE="http://www.openca.info/"
SRC_URI="mirror://sourceforge/openca/${P}.tar.gz"

LICENSE="Apache"
SLOT="0"
# Mask it since CGI-Session is also masked
KEYWORDS="~x86"
IUSE="postgres"
RDEPEND="postgres? ( dev-db/postgresql )"

DEPEND="$RDEPEND
		dev-perl/Authen-SASL
        dev-perl/Convert-ASN1
        dev-perl/Compress-Zlib
        dev-perl/CGI-Session
        dev-perl/Crypt-SSLeay
        dev-perl/DBD-Pg
        dev-perl/DBI
        dev-perl/Digest-HMAC
        dev-perl/Digest-SHA1
        dev-perl/HTML-Parser
        dev-perl/HTML-Tagset
        dev-perl/IO-Socket-SSL
        dev-perl/IO-stringy
        dev-perl/libnet
        dev-perl/libwww-perl
        dev-perl/Locale-gettext
        dev-perl/Log-Agent
        dev-perl/MailTools
        dev-perl/MIME-Lite
        dev-perl/MIME-tools
        dev-perl/MIME-Types
        dev-perl/Net-Daemon
        dev-perl/Net-SSLeay
        dev-perl/net-server
        dev-perl/PlRPC
        dev-perl/Parse-RecDescent
        dev-perl/perl-ldap
        dev-perl/TermReadKey
        dev-perl/URI
        dev-perl/X500-DN
        dev-perl/XML-Parser
        dev-perl/XML-Twig
        perl-core/CGI
        perl-core/digest-base
        perl-core/Digest-MD5
        perl-core/MIME-Base64
        perl-core/Storable
        perl-core/Test-Harness
        perl-core/Test-Simple"

pkg_setup() {
	# Create OpenCA Group and User
    enewgroup openca
    enewuser openca -1 -1 /dev/null openca
}

src_compile() {
	# CD into source dir
	cd ${S}
	# Patch relative_link.sh
	epatch ${FILESDIR}/${P}.patch || die "Patching failed"
	# configure
	econf --disable-external-modules --prefix=/usr/local/openca \
		--with-openca-user=openca --with-openca-group=openca \
		--with-httpd-user=apache --with-httpd-group=apache \
		--enable-dbi || die "configure problem"
	# make
	emake || die "compile problem"
}

src_install() {
	# install into image dir and display only errors with useful output
	emake DESTDIR=${D} install-offline 
	# If it doesn't work... this shows only errors while installing
	# 2>&1 | grep -i -A3 -B30 error
}

