package samples.businessnew;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardService;
import opencard.core.service.SmartCard;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

/**
 * Creates instances of the Card Service <tt>BusinessCardProxy</tt> for JavaCards.
 *
 * @author Frank Seliger (seliger@de.ibm.com)
 */
public class BusinessCardProxyFactory extends CardServiceFactory {
	/** Card type that identifies the cards for which this factory can create services. */
	public final static int JC_TYPE_2 = 0x02;

	/** Tracer for logging. */
	private Tracer itracer = new Tracer(this, BusinessCardProxyFactory.class);

	/** Holds the services which are available. */
	private static Vector services_ = new Vector();

	// This factory can create instances of BusinessCardProxy.
	static {
		services_.addElement(BusinessCardProxy.class);
	}
/**
 * Constructs an object of this class.
 */
public BusinessCardProxyFactory() {
}
/**
 * Indicate whether this <tt>CardServiceFactory</tt> supports cards of this type and/or
 * installed card applications.  Would it be able to instantiate a <tt>CardService</tt>s 
 * for cards of this type?
 * <p>
 * This factory does not read the card, rather it only judges from the card's ATR.
 *
 * @param cid       A <tt>CardID</tt> received from a <tt>Slot</tt>.
 * @param scheduler A <tt>CardServiceScheduler</tt> that could be used to communicate with
 *                  the card to determine its type.  It is not used by this factory.
 *
 * @return A valid CardType if the factory can instantiate services for this card.
 *         CardType.UNSUPPORTED if the factory does not support the card.
 *
 * @see ##getClassFor
 */
protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
	byte[] historicalBytes = cid.getHistoricals();
	byte[] IBM_JC_HIST = {(byte) 0x80, (byte) 0x31, (byte) 0xC0, (byte) 0x6B, (byte) 0x49, 
						  (byte) 0x42, (byte) 0x4D, (byte) 0x20, (byte) 0x4A, (byte) 0x65,
						  (byte) 0x74, (byte) 0x5A, (byte) 0x20, (byte) 0x4D, (byte) 0x32};
	short s;
	for (s = 0; s <= 12; s++) {
		if (historicalBytes[s] != IBM_JC_HIST[s]) {
			return CardType.UNSUPPORTED;
		}
	}
	return new CardType(JC_TYPE_2);
}
/**
 * Returns an enumeration of known <tt>CardService</tt> classes.
 *
 * @param type The <tt>CardType</tt> for which to enumerate.
 *
 * @return An <tt>Enumeration</tt> of class objects.
 */
protected Enumeration getClasses(CardType type) {
	if (type.getType() == JC_TYPE_2) {
		return services_.elements();
	} else {
		return (new Vector()).elements();
	}
}
}
