package samples.businessnew;

/**
 * BusinessInfo encapsulates a business information entry as can be stored by 
 * the BusinessCardApplet.
 *
 * @author  Thomas Schaeck (schaeck@de.ibm.com)
 * @version $Id: BusinessInfo.java,v 1.1 1998/09/02 16:12:08 cvsusers Exp $
 */
public class BusinessInfo {
	/** The name. */
	protected String name_ = null;

	/** The title. */
	protected String title_ = null;

	/** The e-mail address. */
	protected String email_ = null;

	/** The phone number. */
	protected String phone_ = null;

	/** The address. */
	protected String address_ = null;

/**
 * Creates a new BusinessInfo instance for a person.
 *
 * @param name    The name of the person.
 * @param title   The title of the person.
 * @param email   The E-mail address of the person.
 * @param phone   The phone number of the person.
 * @param address The address of the person.
 */
public BusinessInfo(String name, String title, String email, String phone, String address) {
	name_ = name;
	title_ = title;
	email_ = email;
	phone_ = phone;
	address_ = address;
}
/**
 * Gets the address.
 *
 * @return The address.
 */
public String getAddress() {
	return address_;
}
/**
 * Gets the e-mail address.
 *
 * @return The e-mail address.
 */
public String getEmail() {
	return email_;
}
/**
 * Gets the name.
 *
 * @return The name.
 */
public String getName() {
	return name_;
}
/**
 * Gets the phone number.
 *
 * @return The phone number.
 */
public String getPhone() {
	return phone_;
}
/**
 * Gets the title.
 *
 * @return The title.
 */
public String getTitle() {
	return title_;
}
/**
 * Sets the address.
 *
 * @param address The address.
 */
public void setAddress(String address) {
	address_ = address;
}
/**
 * Sets the E-mail address.
 *
 * @param email The E-mail address.
 */
public void setEmail(String email) {
	email_ = email;
}
/**
 * Sets the name.
 *
 * @param name The name.
 */
public void setName(String name) {
	name_ = name;
}
/**
 * Sets the phone number.
 *
 * @param phone The phone number.
 */
public void setPhone(String phone) {
	phone_ = phone;
}
/**
 * Sets the title.
 *
 * @param title The title.
 */
public void setTitle(String title) {
	title_ = title;
}
/**
 * Creates a string representing this BusinessInfo object.
 *
 * @return The string representing this object.
 */
public String toString() {
  StringBuffer sb = new StringBuffer();

  sb.append(">");
  sb.append(getTitle());
  sb.append(" ");
  sb.append(getName());
  sb.append("<\n Email: >");
  sb.append(getEmail());
  sb.append("<\n Phone: >");
  sb.append(getPhone());
  sb.append("<\n Address: >");
  sb.append(getAddress());
  sb.append("<");

  return sb.toString();
}
}
