package samples.businessnew;

/*
 * Copyright  1998 - 2000 IBM Corporation.
 *
 * Redistribution and use in source (source code) and binary (object code)
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributed source code must retain the above copyright notice, this
 * list of conditions and the disclaimer below.
 * 2. Redistributed object code must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of IBM may not be used to endorse or promote products derived
 * from this software or in any other form without specific prior written
 * permission from IBM.
 * 4. Redistribution of any modified code must be labeled "Code derived from
 * the original OpenCard Framework".
 *
 * THIS SOFTWARE IS PROVIDED BY IBM "AS IS" FREE OF CHARGE. IBM SHALL NOT BE
 * LIABLE FOR INFRINGEMENTS OF THIRD PARTIES RIGHTS BASED ON THIS SOFTWARE.  ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IBM DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THIS
 * SOFTWARE WILL MEET THE USER'S REQUIREMENTS OR THAT THE OPERATION OF IT WILL
 * BE UNINTERRUPTED OR ERROR-FREE.  IN NO EVENT, UNLESS REQUIRED BY APPLICABLE
 * LAW, SHALL IBM BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ALSO, IBM IS UNDER NO OBLIGATION
 * TO MAINTAIN, CORRECT, UPDATE, CHANGE, MODIFY, OR OTHERWISE SUPPORT THIS
 * SOFTWARE.
 */

import javacard.framework.Util;

/**
 * A Field in a Business Card Record, as it is stored on the JavaCard
 *
 */
public class BizCardField  {
	byte[] data;
	   short  length;


/**
 * Construct a Business Card Field from a byte array (deep copy).
 * @param bytes  - byte[] containing the data contents
 * @param bufferSize - short specifying the size of the reusable buffer
 */
public BizCardField ( byte[] bytes, short bufferSize) {
	   data = new byte[bufferSize];
	   this.update(bytes);
}
/**
 * Construct an empty Business Card Field
 * @param bufferSize - short specifying the size of the reusable buffer
 */
public BizCardField ( short bufferSize) {
	   data = new byte[bufferSize];
	   data[0] = (byte)'?';
	   length = 1;
}
/**
 * Update a Business Card Field from a byte array (deep copy)
 * @param bytes - byte[] containing the new data
 */
public void update( byte[] bytes) {
	   update(bytes, (short)0, (short)bytes.length);
}
/**
 * Update a Business Card Field from a byte array (deep copy)
 * @param bytes - byte[] containing the new data
 * @param offset - offset in the source bytes
 * @param lng - length of update data
 */
public void update( byte[] bytes, short offset, short lng) {
	   length = lng;
	   if (length > data.length) {     // Get a larger buffer.  This is not
		   byte [] oldData = data;     // ... always a good strategy on a
		   data = new byte[length];    // ... Java Card.  It could fail when
									   // ... the memory is filled up.
	   }
	   Util.arrayCopy(bytes, offset, data, (short)0, length);
}
}
