package samples.businessnew;

/*
 * Copyright  1998 - 2000 IBM Corporation.
 *
 * Redistribution and use in source (source code) and binary (object code)
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributed source code must retain the above copyright notice, this
 * list of conditions and the disclaimer below.
 * 2. Redistributed object code must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of IBM may not be used to endorse or promote products derived
 * from this software or in any other form without specific prior written
 * permission from IBM.
 * 4. Redistribution of any modified code must be labeled "Code derived from
 * the original OpenCard Framework".
 *
 * THIS SOFTWARE IS PROVIDED BY IBM "AS IS" FREE OF CHARGE. IBM SHALL NOT BE
 * LIABLE FOR INFRINGEMENTS OF THIRD PARTIES RIGHTS BASED ON THIS SOFTWARE.  ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IBM DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THIS
 * SOFTWARE WILL MEET THE USER'S REQUIREMENTS OR THAT THE OPERATION OF IT WILL
 * BE UNINTERRUPTED OR ERROR-FREE.  IN NO EVENT, UNLESS REQUIRED BY APPLICABLE
 * LAW, SHALL IBM BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ALSO, IBM IS UNDER NO OBLIGATION
 * TO MAINTAIN, CORRECT, UPDATE, CHANGE, MODIFY, OR OTHERWISE SUPPORT THIS
 * SOFTWARE.
 */

import javacard.framework.ISO;  // (JavaCard 2.1 Spec calls it ISO7816)
import javacard.framework.ISOException;

/**
 * A Business Card Record, as it is stored on the JavaCard.  Each record
 * has the same fixed size.
 */
public class BizCardRecord  {
	private BizCardField bcf0;
	private BizCardField bcf1;
	private BizCardField bcf2;
	private BizCardField bcf3;
	private BizCardField bcf4;

/**
 * Construct an empty BizCardRecord
 */
public BizCardRecord () {
	   this.init();
}
/**
 * Construct a BizCardRecord from five byte arrays
 */
public BizCardRecord ( byte[] f0, byte[] f1, byte[] f2, byte[] f3, byte[] f4) {
	   this.init();
	   bcf0.update(f0);
	   bcf1.update(f1);
	   bcf2.update(f2);
	   bcf3.update(f3);
	   bcf4.update(f4);
}
/**
 * Return the n-th field.  As with arrays, n starts with 0.
 */
public BizCardField getField(byte n) {
	   BizCardField field = null;
	   switch (n) {
		   case 0x00 : field = bcf0; break;
		   case 0x01 : field = bcf1; break;
		   case 0x02 : field = bcf2; break;
		   case 0x03 : field = bcf3; break;
		   case 0x04 : field = bcf4; break;
		   default   : ISOException.throwIt(ISO.SW_WRONG_P1P2);
	   }
	   return field;
}
/**
 * Private function to initialize an empty BizCardRecord
 */
private void init() {
	 	bcf0 = new BizCardField( (short)20);
	 	bcf1 = new BizCardField( (short)14);
	 	bcf2 = new BizCardField( (short)27);
	 	bcf3 = new BizCardField( (short)20);
	 	bcf4 = new BizCardField( (short)50);
}
/**
 * Set the n-th field.  As with arrays, n starts with 0.
 */
public void setField(byte n, byte[] bytes) {
	   setField(n, bytes, (short)0, (short)bytes.length);
	   return;
}
/**
 * Set the n-th field.  As with arrays, n starts with 0.
 */
public void setField(byte n, byte[] bytes, short offset, short length) {
	   switch (n) {
		   case 0x00 : bcf0.update(bytes, offset, length); break;
		   case 0x01 : bcf1.update(bytes, offset, length); break;
		   case 0x02 : bcf2.update(bytes, offset, length); break;
		   case 0x03 : bcf3.update(bytes, offset, length); break;
		   case 0x04 : bcf4.update(bytes, offset, length); break;
		   default   : ISOException.throwIt(ISO.SW_WRONG_P1P2);
	   }
	   return;
}
}
