package samples.businessnew;

/*
 * Copyright  1998 - 2000 IBM Corporation.
 *
 * Redistribution and use in source (source code) and binary (object code)
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributed source code must retain the above copyright notice, this
 * list of conditions and the disclaimer below.
 * 2. Redistributed object code must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of IBM may not be used to endorse or promote products derived
 * from this software or in any other form without specific prior written
 * permission from IBM.
 * 4. Redistribution of any modified code must be labeled "Code derived from
 * the original OpenCard Framework".
 *
 * THIS SOFTWARE IS PROVIDED BY IBM "AS IS" FREE OF CHARGE. IBM SHALL NOT BE
 * LIABLE FOR INFRINGEMENTS OF THIRD PARTIES RIGHTS BASED ON THIS SOFTWARE.  ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IBM DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THIS
 * SOFTWARE WILL MEET THE USER'S REQUIREMENTS OR THAT THE OPERATION OF IT WILL
 * BE UNINTERRUPTED OR ERROR-FREE.  IN NO EVENT, UNLESS REQUIRED BY APPLICABLE
 * LAW, SHALL IBM BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ALSO, IBM IS UNDER NO OBLIGATION
 * TO MAINTAIN, CORRECT, UPDATE, CHANGE, MODIFY, OR OTHERWISE SUPPORT THIS
 * SOFTWARE.
 */

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardService;
import opencard.core.service.SmartCard;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

/**
 * Creates instances of the Card Service <tt>BusinessCardProxy</tt> for JavaCards.
 *
 * @author Frank Seliger (seliger@de.ibm.com)
 */
public class BusinessCardProxyFactory extends CardServiceFactory {
	/** Card type that identifies the cards for which this factory can create services. */
	public final static int JC_TYPE_2 = 0x02;

	/** Tracer for logging. */
	private Tracer itracer = new Tracer(this, BusinessCardProxyFactory.class);

	/** Holds the services which are available. */
	private static Vector services_ = new Vector();

	// This factory can create instances of BusinessCardProxy.
	static {
		services_.addElement(BusinessCardProxy.class);
	}
/**
 * Constructs an object of this class.
 */
public BusinessCardProxyFactory() {
}
/**
 * Indicate whether this <tt>CardServiceFactory</tt> supports cards of this type and/or
 * installed card applications.  Would it be able to instantiate a <tt>CardService</tt>s 
 * for cards of this type?
 * <p>
 * This factory does not read the card, rather it only judges from the card's ATR.
 *
 * @param cid       A <tt>CardID</tt> received from a <tt>Slot</tt>.
 * @param scheduler A <tt>CardServiceScheduler</tt> that could be used to communicate with
 *                  the card to determine its type.  It is not used by this factory.
 *
 * @return A valid CardType if the factory can instantiate services for this card.
 *         CardType.UNSUPPORTED if the factory does not support the card.
 *
 * @see ##getClassFor
 */
protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
	byte[] historicalBytes = cid.getHistoricals();
	byte[] IBM_JC_HIST = {(byte) 0x80, (byte) 0x31, (byte) 0xC0, (byte) 0x6B, (byte) 0x49, 
						  (byte) 0x42, (byte) 0x4D, (byte) 0x20, (byte) 0x4A, (byte) 0x65,
						  (byte) 0x74, (byte) 0x5A, (byte) 0x20, (byte) 0x4D, (byte) 0x32};
	short s;
	for (s = 0; s <= 12; s++) {
		if (historicalBytes[s] != IBM_JC_HIST[s]) {
			return CardType.UNSUPPORTED;
		}
	}
	return new CardType(JC_TYPE_2);
}
/**
 * Returns an enumeration of known <tt>CardService</tt> classes.
 *
 * @param type The <tt>CardType</tt> for which to enumerate.
 *
 * @return An <tt>Enumeration</tt> of class objects.
 */
protected Enumeration getClasses(CardType type) {
	return services_.elements();
}
}
