package samples.businessnew;

/*
 * Copyright  1998 - 2000 IBM Corporation.
 *
 * Redistribution and use in source (source code) and binary (object code)
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributed source code must retain the above copyright notice, this
 * list of conditions and the disclaimer below.
 * 2. Redistributed object code must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of IBM may not be used to endorse or promote products derived
 * from this software or in any other form without specific prior written
 * permission from IBM.
 * 4. Redistribution of any modified code must be labeled "Code derived from
 * the original OpenCard Framework".
 *
 * THIS SOFTWARE IS PROVIDED BY IBM "AS IS" FREE OF CHARGE. IBM SHALL NOT BE
 * LIABLE FOR INFRINGEMENTS OF THIRD PARTIES RIGHTS BASED ON THIS SOFTWARE.  ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IBM DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THIS
 * SOFTWARE WILL MEET THE USER'S REQUIREMENTS OR THAT THE OPERATION OF IT WILL
 * BE UNINTERRUPTED OR ERROR-FREE.  IN NO EVENT, UNLESS REQUIRED BY APPLICABLE
 * LAW, SHALL IBM BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ALSO, IBM IS UNDER NO OBLIGATION
 * TO MAINTAIN, CORRECT, UPDATE, CHANGE, MODIFY, OR OTHERWISE SUPPORT THIS
 * SOFTWARE.
 */

import opencard.opt.applet.AppletState;

/**
 * BusinessCardState represents the state of an arbitrary <tt>BusinessCardApplet</tt>
 * on a JavaCard. 
 * The state indicates whether card holder verification must be performed 
 * before the applet may ba accessed.
 *
 * @author Thomas Schaeck (schaeck@de.ibm.com)
 * @version $Id: BusinessCardState.java,v 1.1 1998/09/02 16:12:08 cvsusers Exp $
 */
public class BusinessCardState extends AppletState {
	/** Remembers whether a successful card holder verification has been performed. */
	protected boolean chvPerformed_ = false;
  /**
   * This method is expected to be called by the select methods of proxies
   * which are not assiciated to the same applet as the state object
   * to indicate when the applet associated with this state is deselected.
   */
  public void appletDeselected() {
	chvPerformed_ = false;
  }    
  /**
   * Checks whether a successful card holder verification has already
   * been performed.
   *
   * @return true if a successful card holder verification has been
   *         performed, false otherwise.
   */
  public boolean isCHVPerformed() {
	return chvPerformed_;
  }    
  /**
   * Sets the card holder verification flag to the given value.
   *
   * @param chvPerformed Indicates whether a successful
   *                     card holder verification has been performed;
   *                     true indicates yes, false indicates no.
   */
  public void setCHVPerformed(boolean chvPerformed) {
	chvPerformed_ = chvPerformed;
  }    
}
