/*
 * Copyright (c) 2005 Cisco Systems.  All rights reserved.
 * Copyright (c) 2005 Voltaire, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <Python.h>

#include <linux/types.h>
#include <linux/ioctl.h>

struct ib_user_mad_reg_req {
	__u32	id;
	__u32	method_mask[4];
	__u8	qpn;
	__u8	mgmt_class;
	__u8	mgmt_class_version;
	__u8    oui[3];
	__u8	rmpp_version;
};

#define IB_IOCTL_MAGIC		0x1b

#define IB_USER_MAD_REGISTER_AGENT	_IOWR(IB_IOCTL_MAGIC, 1, \
					      struct ib_user_mad_reg_req)

#define IB_USER_MAD_UNREGISTER_AGENT	_IOW(IB_IOCTL_MAGIC, 2, __u32)

static PyMethodDef UmadIoctlMethods[] = {
	{ NULL }
};

PyMODINIT_FUNC initumadioctl(void)
{
	PyObject *mod, *dict;
	PyObject *tmp;

	mod = Py_InitModule("umadioctl", UmadIoctlMethods);
	dict = PyModule_GetDict(mod);

	tmp = PyInt_FromLong(IB_USER_MAD_REGISTER_AGENT);
	PyDict_SetItemString(dict, "REGISTER_AGENT", tmp);
	Py_DECREF(tmp);

	tmp = PyInt_FromLong(IB_USER_MAD_UNREGISTER_AGENT);
	PyDict_SetItemString(dict, "UNREGISTER_AGENT", tmp);
	Py_DECREF(tmp);
}
